<?php


class EbayAPI extends Database {
	private $urlBase = "https://api.ebay.com";
	private $urlBaseSandbox = "https://api.sandbox.ebay.com";
	private $moduleUrlSections = array(
		'order' => "/sell/fulfillment/v1/order",
		'bulk_get_inventory_item' => "/sell/inventory/v1/bulk_get_inventory_item",
		'identity' => '/identity/v1/oauth2/token'
	);

	private $tokenPath = "";

	private $accessTokenName = "ebay_oauth.txt";
	private $refreshTokenName = "ebay_refresh.txt";

	private $oauthScopesList = "https://api.ebay.com/oauth/api_scope/sell.marketing https://api.ebay.com/oauth/api_scope/sell.inventory.readonly https://api.ebay.com/oauth/api_scope/sell.inventory https://api.ebay.com/oauth/api_scope/sell.fulfillment.readonly https://api.ebay.com/oauth/api_scope/sell.fulfillment";

	private $loginUrl = "https://auth.ebay.com/oauth2/authorize?client_id=MyServic-OrderCon-PRD-d6e504789-82ee7d38&response_type=code&redirect_uri=MyService_Solut-MyServic-OrderC-ztvxrmnvv&scope=https://api.ebay.com/oauth/api_scope https://api.ebay.com/oauth/api_scope/sell.marketing.readonly https://api.ebay.com/oauth/api_scope/sell.marketing https://api.ebay.com/oauth/api_scope/sell.inventory.readonly https://api.ebay.com/oauth/api_scope/sell.inventory https://api.ebay.com/oauth/api_scope/sell.account.readonly https://api.ebay.com/oauth/api_scope/sell.account https://api.ebay.com/oauth/api_scope/sell.fulfillment.readonly https://api.ebay.com/oauth/api_scope/sell.fulfillment https://api.ebay.com/oauth/api_scope/sell.analytics.readonly https://api.ebay.com/oauth/api_scope/sell.finances https://api.ebay.com/oauth/api_scope/sell.payment.dispute https://api.ebay.com/oauth/api_scope/commerce.identity.readonly";

	private $refreshScopes = "https://api.ebay.com/oauth/api_scope%20https://api.ebay.com/oauth/api_scope/sell.marketing.readonly%20https://api.ebay.com/oauth/api_scope/sell.marketing%20https://api.ebay.com/oauth/api_scope/sell.inventory.readonly%20https://api.ebay.com/oauth/api_scope/sell.inventory%20https://api.ebay.com/oauth/api_scope/sell.account.readonly%20https://api.ebay.com/oauth/api_scope/sell.account%20https://api.ebay.com/oauth/api_scope/sell.fulfillment.readonly%20https://api.ebay.com/oauth/api_scope/sell.fulfillment%20https://api.ebay.com/oauth/api_scope/sell.analytics.readonly%20https://api.ebay.com/oauth/api_scope/sell.finances%20https://api.ebay.com/oauth/api_scope/sell.payment.dispute%20https://api.ebay.com/oauth/api_scope/commerce.identity.readonly";

	private $ruNameValue = "MyService_Solut-MyServic-OrderC-ztvxrmnvv";

	private $clientId = array(
		'DEV' => 'MyServic-OrderCon-SBX-f6e504789-d2483e42',
		'PROD' => 'MyServic-OrderCon-PRD-d6e504789-82ee7d38'
	);
	private $clientSecret = array(
		'DEV' => 'SBX-6e504789f4f7-bd9d-4b85-a2cc-e192',
		'PROD' => 'PRD-6e5047892a99-c6d6-4c81-8a19-3950'
	);

	function __construct() {
		$this->tokenPath = HTML_FOLDER . "apis/ebay/tokens/"; // For php 5.4 CLI compatibility
	}

	private function getFreshToken() {
		$url = $this->getUrl('identity');
		if ($this->isRefreshTokenExpired()) {
			$this->redirectToLoginPage();
			return false;
		}
		else {
			$clientToken = $this->getBasicToken();
			$refreshTokenData = $this->getRefreshToken();
			$refreshToken = $refreshTokenData['refresh_token'];
			$scope = $this->refreshScopes;
			$requestHeaders = array(
				"Content-Type: application/x-www-form-urlencoded",
				"Authorization: Basic $clientToken"
			);
			$requestBody = "grant_type=refresh_token&refresh_token=$refreshToken&scope=$scope";
			$response = $this->curl_post_2($url, $requestBody, $requestHeaders);
			$decodedResponse = json_decode($response);
			if (!$decodedResponse->error) {
				$accessToken = array(
					"access_token" => $decodedResponse->access_token,
					"expires" => time() + $decodedResponse->expires_in
				);
				$accessTokenPath = $this->getAccessTokenPath();
				try {
					if (!file_exists($accessTokenPath)) {
						mkdir($accessTokenPath, 0700, true);
					}
				}
				catch (Exception $e) {
					echo $e;
				}
				$result = file_put_contents($accessTokenPath, json_encode($accessToken));
				return true;
			}
		}
	}

	public function getUnfulfilledOrders($decode=false) {
		$url = $this->getUrl('order');
		$url .= '?filter=orderfulfillmentstatus:%7BNOT_STARTED%7CIN_PROGRESS%7D';
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"X-EBAY-C-MARKETPLACE-ID: EBAY-US",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_get_2($url, $requestHeaders);
		if ($decode) {
			$results = json_decode($results);
		}
		return $results;
	}

	public function getRefundHistory() {
		$orders = $this->getReturnedOrders();
		foreach ($orders as $order) {
			$orderId = $order->orderId;
			$returnDate = new DateTime($order->refundPayments[0]->refundDate, new DateTimeZone('UTC'));
			$returnAmount = 0.0;
			foreach ($order->refundPayments as $payment) {
				$returnAmount += (float)$payment->amount->value;
			}
			$returnDate = $returnDate->format('Y-m-d H:i:s');
			$ecommId = $this->getEcommId($orderId);
			if ($ecommId) {
				$sql = "INSERT INTO `ecomm_return_log`(`ecomm_id`, `return_date`, `return_amount`) VALUES ('$ecommId', '$returnDate', '$returnAmount') ON DUPLICATE KEY UPDATE `return_date`='$returnDate', `return_amount`='$returnAmount';";
				$this->db_query($sql, 'insert', true);
			}
			else {
				echo "\nNo ecomm id found for $orderId\n";
			}
		}
	}

	public function getReturnedOrders() {
		$url = $this->getUrl('order');
		$url .= '?filter=orderfulfillmentstatus:%7BFULFILLED%7CIN_PROGRESS%7D&limit=1000';
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"X-EBAY-C-MARKETPLACE-ID: EBAY-US",
			"Authorization: Bearer $accessToken"
		);
		$results = json_decode($this->curl_get_2($url, $requestHeaders));
		$orders = $results->orders;
		$refunds = array();
		foreach($orders as $order) {
			if ($order->orderPaymentStatus == "PARTIALLY_REFUNDED" || $order->orderPaymentStatus == "FULLY_REFUNDED") {
				$refundData = new stdClass;
				$refundData->orderId = $order->orderId;
				$refundData->legacyOrderId = $order->legacyOrderId;
				$refundData->refundPayments = $order->paymentSummary->refunds;
				array_push($refunds, $refundData);
			}
		}
		return $refunds;
	}



	public function getOrder($orderId) {
		$url = $this->getUrl('order');
		$url .= "/$orderId";
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"X-EBAY-C-MARKETPLACE-ID: EBAY-US",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_get_2($url, $requestHeaders);
		return $results;
	}

	public function getOrders($fromDate='', $limit=50, $offset=0) {
		$url = $this->getUrl('order');
		$i = 0;
		if ($fromDate != '') {
			if ($i) {
				$url .= "&";
			} else {
				$url .= "?";
			}
			$fromDate .= "T00:00:00.000Z";
			$url .= "filter=creationdate:%5B$fromDate..%5D";
			$i++;
		}
		if ($limit != 50) {
			if ($i) {
				$url .= "&";
			} else {
				$url .= "?";
			}
			$url .= "limit=$limit";
			$i++;
		}
		if ($offset != 0) {
			if ($i) {
				$url .= "&";
			} else {
				$url .= "?";
			}
			$url .= "offset=$offset";
		}
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"X-EBAY-C-MARKETPLACE-ID: EBAY-US",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_get_2($url, $requestHeaders);
		return $results;
	}

	public function bulkGetInventoryItem($requestJson) {
		$url = $this->getUrl('bulk_get_inventory_item');
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"Content-Type: application/json",
			"Accept: application/json",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_post_2($url, $requestJson, $requestHeaders);
		return $results;
	}

	public function createShippingFulfillment($orderId, $shippingFulfillment) {
		$url = $this->getUrl('order');
		$url .= "/$orderId/shipping_fulfillment";
		$accessToken = $this->getValidAccessToken();
		$requestJson = json_encode($shippingFulfillment);
		$requestHeaders = array(
			"Content-Type: application/json",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_post_2($url, $requestJson, $requestHeaders);
		return $results;
	}

	public function getShippingFulfillments($orderId) {
		$url = $this->getUrl('order');
		$url .= "/$orderId/shipping_fulfillment";
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"X-EBAY-C-MARKETPLACE-ID: EBAY-US",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_get_2($url, $requestHeaders);
		return $results;
	}

	public function getShippingFulfillment($orderId, $fulfillmentId) {
		$url = $this->getUrl('order');
		$url .= "/$orderId/shipping_fulfillment/$fulfillmentId";
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		$accessToken = $accessTokenData['access_token'];
		$requestHeaders = array(
			"X-EBAY-C-MARKETPLACE-ID: EBAY-US",
			"Authorization: Bearer $accessToken"
		);
		$results = $this->curl_get_2($url, $requestHeaders);
		return $results;
	}

	private function getRefreshToken() {
		$path = $this->getRefreshTokenPath();
		$token = json_decode(file_get_contents($path), true);
		return $token;
	}

	private function getValidAccessToken() {
		if ($this->isAccessTokenExpired()) {
			$this->getFreshToken();
		}
		$accessTokenData = $this->getAccessToken();
		return $accessTokenData['access_token'];
	}

	private function getAccessToken() {
		$path = $this->getAccessTokenPath();
		$token = json_decode(file_get_contents($path), true);
		return $token;
	}

	private function isRefreshTokenExpired() {
		$token = $this->getRefreshToken();
		if (!$token || time() > $token['expires']) {
			return true;
		}
		else {
			return false;
		}
	}

	private function isAccessTokenExpired() {
		$token = $this->getAccessToken();
		if (!$token || time() > $token['expires']) {
			return true;
		}
		else {
			return false;
		}
	}

	private function getRefreshTokenPath() {
		return $this->tokenPath . $this->refreshTokenName;
	}

	private function getAccessTokenPath() {
		return $this->tokenPath . $this->accessTokenName;
	}

	public function handleLogin($environment='PROD') {
		$accessTokenPath = $this->getAccessTokenPath();
		$refreshTokenPath = $this->getRefreshTokenPath();
		$code = $_GET['code'];
		$token = $this->getBasicToken($environment);
		$redirectUri = $this->ruNameValue;
		$url = $this->getUrl('identity');
		$requestHeaders = array(
			"Content-Type: application/x-www-form-urlencoded",
			"Authorization: Basic $token"
		);
		$requestBody = "grant_type=authorization_code&code=$code&redirect_uri=$redirectUri";
		$response = $this->curl_post_2($url, $requestBody, $requestHeaders);
		$decodedResponse = json_decode($response);
		if (!$decodedResponse->error) {
			$authToken = array(
				"access_token" => $decodedResponse->access_token,
				"expires" => time() + $decodedResponse->expires_in
			);
			$refreshToken = array(
				"refresh_token" => $decodedResponse->refresh_token,
				"expires" => time() + $decodedResponse->refresh_token_expires_in
			);
			try {
				if (!file_exists($accessTokenPath)) {
					mkdir($accessTokenPath, 0700, true);
				}
				if (!file_exists($refreshTokenPath)) {
					mkdir($refreshTokenPath, 0700, true);
				}
			}
			catch (Exception $e) {
				echo $e;
			}
			file_put_contents($accessTokenPath, json_encode($accessToken));
			file_put_contents($refreshTokenPath, json_encode($refreshToken));
		}
	}

	public function redirectToLoginPage() {
		$url = $this->loginUrl;
		header("Location: $url");
	}

	public function getBasicToken($environment='PROD') {
		return base64_encode($this->clientId[$environment] . ":" . $this->clientSecret[$environment]);
	}

	private function getUrl($module, $id='', $submodule='', $submoduleId='') {
		$url = $this->urlBase;
		$url .= $this->moduleUrlSections[$module];
		if ($id) {
			$url .= "/$id";
			// Submodule check is inside id check because cannot have submodule without top level id
			if ($submodule) {
				$url .= "/$submodule";
				if ($submoduleId) {
					$url .= "/$submoduleId";
				}
			}
		}
		return $url;
	}

	public function getChannelId($channel='auctions') {
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='ebay_$channel' LIMIT 1";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['id'];
	}

	public function getEcommId($orderId) {
		$sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId';";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['id'];
	}
}
