<?php

class DropboxUpload {
	// private static $chunkSize = 4194304; //125829120;
	private static $chunkSize = 125829120; // 120 mb

	public static function upload($fileName, $filePath='', $verbose=false) {
		if (!$filePath) {
			$filePath = __DIR__ . "/tmp/$fileName";
		}
		$fileSize = self::getFileSize($filePath);
		if ($fileSize > 0) {
			if ($fileSize >= 104857600) {
				// If larger than 100 megabytes, start a file upload session
				self::uploadSession($fileName, $filePath, $fileSize, $verbose);
			}
			else {
				// Otherwise, perform a standard upload
			}

		}
		else {
			throw new Exception('Filesize could not be read.');
		}
	}

	private static function uploadSingle($appData, $filePath) {
		$url = 'https://content.dropboxapi.com/2/files/upload';
	}

	private static function uploadSession($fileName, $filePath, $fileSize, $verbose=false) {
		if ($verbose) {
			echo "<pre>\n";
			echo "Total filesize: $fileSize bytes\n";
		}
		$numChunks = ceil($fileSize / self::$chunkSize);
		$bytesSent = 0;
		$chunkSize = self::$chunkSize;
		try {
			$sessionId = self::uploadSessionStart($verbose);

			if ($verbose) {
				echo "Got session ID: $sessionId\n";
				echo "Preparing to upload $fileName in $numChunks chunks of $chunkSize bytes each.\n";
				echo "Opening file path: $filePath\n";
			}
			$handle = fopen($filePath, 'rb');

			for ($i = 0; $i < $numChunks; $i++) {
				$chunk = fread($handle, $chunkSize);
				$finalByte = $bytesSent + $chunkSize <= $fileSize ? $bytesSent + $chunkSize : $fileSize;
				if ($verbose) {
					echo "Sending bytes $bytesSent to $finalByte\n";
				}
				if ($i == $numChunks-1) {
					if ($verbose) {
						echo "Final chunk. Closing session.\n";
					}
					$close = true;
				}
				else {
					$close = false;
				}
				self::uploadSessionAppend($sessionId, $bytesSent, $chunk, $close, $verbose);
				$bytesSent += min($finalByte, $chunkSize);
			}

			fclose($handle);

			if ($verbose) {
				echo "Uploaded $fileName, preparing to finish session\n";
			}

			$closeSessionResponse = self::uploadSessionFinish($sessionId, $bytesSent, $fileName, $verbose);
		}
		catch (Exception $e) {
			echo $e->getMessage() . "\n";
		}

		if ($verbose) {
			echo "</pre>\n";
		}
	}

	private static function uploadSessionStart($verbose=false) {
		$url = "https://content.dropboxapi.com/2/files/upload_session/start";
		$accessToken = DropboxAuth::getValidAccessToken($verbose);
		if ($accessToken) {
			$headers = array(
				"Authorization: Bearer $accessToken",
				'Dropbox-API-Arg: {"close": false, "session_type": "concurrent"}',
				"Content-Type: application/octet-stream"
			);
			$response = json_decode(Curl::post($url, null, $headers));
			if ($response->session_id) {
				return $response->session_id;
			}
			else {
				$errorMessage = "Could not start session";
				if ($response->error) {
					$error = (array)$response->error;
					$error = $error['.tag'];
					$errorSummary = $response->error_summary;
					$errorMessage .= "\nError: $error\nError Summary: $errorSummary";
				}
				else {
					$errorMessage .= "\nNo response from API";
				}
				throw new Exception($errorMessage);
			}
		}
		else {
			throw new Exception("Could not fetch access token");
		}
	}

	private static function uploadSessionAppend($sessionId, $offset, $chunk, $close=false, $verbose=false) {
		$cursor = new stdClass;
		$cursor->session_id = $sessionId;
		$cursor->offset = $offset;

		$args = new stdClass;
		$args->cursor = $cursor;
		$args->close = $close;

		$url = "https://content.dropboxapi.com/2/files/upload_session/append_v2";
		$accessToken = DropboxAuth::getValidAccessToken($verbose);

		if ($accessToken) {
			$argsEncoded = json_encode($args);
			$headers = array(
				"Authorization: Bearer $accessToken",
				"Dropbox-API-Arg: $argsEncoded",
				"Content-Type: application/octet-stream"
			);
			$response = json_decode(Curl::post($url, $chunk, $headers, null, true));
			if ($response->error) {
				$errorMessage = "Could not upload chunk";
				$error = (array)$response->error;
				$error = $error['.tag'];
				$errorSummary = $response->error_summary;
				$errorMessage .= "\nError: $error\nError Summary: $errorSummary";
				throw new Exception($errorMessage);
			}
		}
		else {
			throw new Exception("Could not fetch access token");
		}
	}

	private static function uploadSessionFinish($sessionId, $offset, $fileName, $verbose=false) {
		$cursor = new stdClass;
		$cursor->session_id = $sessionId;
		$cursor->offset = $offset;

		$commit = new stdClass;
		$commit->path = "/DBBackups/$fileName";
		$commit->mode = "overwrite";
		$commit->autorename = true;
		$commit->mute = false;
		$commit->strict_conflict = false;

		$args = new stdClass;
		$args->cursor = $cursor;
		$args->commit = $commit;

		$url = "https://content.dropboxapi.com/2/files/upload_session/finish";
		$accessToken = DropboxAuth::getValidAccessToken($verbose);

		if ($accessToken) {
			$argsEncoded = json_encode($args);
			$headers = array(
				"Authorization: Bearer $accessToken",
				"Dropbox-API-Arg: $argsEncoded",
				"Content-Type: application/octet-stream"
			);
			$response = json_decode(Curl::post($url, null, $headers));
			if ($response->name) {
				return $response;
			}
			else {
				$errorMessage = "ERROR: Could not close session";
				if ($response->error) {
					$error = (array)$response->error;
					$error = $error['.tag'];
					$errorSummary = $response->error_summary;
					$errorMessage .= "\nAPI Error: $error\nAPI Error Summary: $errorSummary";
				}
				else {
					$errorMessage .= "\nNo response from API";
				}
				throw new Exception($errorMessage);
			}
		}
		else {
			throw new Exception("Could not fetch access token");
		}

		$headers = array(

		);
	}

	private static function getFileSize($filePath) {
		clearstatcache();
		$size = filesize($filePath);
		return $size;
	}
}

?>
