<?php

class DropboxAuth {
	private static $appDetailsFileName = "appDetails.txt"; // for prod
	// private static $appDetailsFileName = "appDetails_test.txt"; // for testing

	private static $refreshTokenFileName = "refreshToken.txt"; // for prod
	// private static $refreshTokenFileName = "refreshToken_test.txt"; // for testing

	private static $accessTokenFileName = "accessToken.txt"; // for prod
	// private static $accessTokenFileName = "accessToken_test.txt"; // for testing




	public static function getAuthUrl() {
		$clientId = self::getClientId();
		if (MODE == 'DEV') {
			$redirectUri = 'https://192.168.7.196/admin_controller.php?m=dropbox_authRedirect';
		}
		else {
			$redirectUri = 'https://macservice.com/admin_controller.php?m=dropbox_authRedirect';
		}
		$url = "https://www.dropbox.com/oauth2/authorize?client_id=$clientId&response_type=code&token_access_type=offline";

		return $url;
	}

	public static function saveAuthorizationCode($authorizationCode) {
		if (!$authorizationCode) {
			return false;
		}
		$fileName = self::$appDetailsFileName;
		// $file = __DIR__ . "/keys/appDetails.txt";
		$file = __DIR__ . "/keys/$fileName"; // for testing
		$data = json_decode(trim(file_get_contents($file)));
		$data->authorizationCode = $authorizationCode;
		$encoded = json_encode($data);
		return file_put_contents($file, $encoded);
	}

	public static function requestRefreshToken() {
		// Get request components
		$appDetails = self::getAppDetails();
		$clientId = $appDetails->clientId;
		$clientSecret = $appDetails->clientSecret;
		$authorizationCode = $appDetails->authorizationCode;

		if ($clientId && $clientSecret && $authorizationCode) { // Only continue if all components present
			$url = "https://api.dropboxapi.com/oauth2/token";
			$data = array(
				'code' => $authorizationCode,
				'grant_type' => 'authorization_code'
			);
			$data = http_build_query($data);
			// echo $data;
			// exit;
			$headers = array(
				"Content-Type: application/x-www-form-urlencoded"
			);
			$user = "$clientId:$clientSecret";

			$response = Curl::post($url, $data, $headers, $user);
			$decodedResponse = json_decode($response);

			if ($decodedResponse && $decodedResponse->refresh_token) {
				$refreshTokenData = new stdClass;
				$refreshTokenData->refreshToken = $decodedResponse->refresh_token;
				$encoded = json_encode($refreshTokenData);

				// Save refresh token first
				$filename = self::$refreshTokenFileName;
				$file = __DIR__ . "/keys/$filename";
				$saveResult = file_put_contents($file, $encoded);

				$accessTokenSaveResult = self::saveAccessToken($decodedResponse);

				return $saveResult;
			}
			else if ($decodedResponse && $decodedResponse->error) {
				echo "<h3>Error:</h3>";
				echo "<pre>";
				print_r($decodedResponse);
				echo "</pre>";
				return false;
			}
		}
		else {
			return false;
		}
	}

	public static function getValidAccessToken($verbose=false) {
		DropboxAuth::refreshAccessToken($verbose);

		return self::getAccessToken();
	}

	public static function refreshAccessToken($verbose=false, $forceRefresh=false) {
		if (!$forceRefresh && self::accessTokenValid($verbose)) {
			return true;
		}
		if ($verbose) {
			echo "Access token expired or invalid. Preparing to fetch new one.\n";
		}
		$refreshToken = self::getRefreshToken();
		$clientId = self::getClientId();
		$clientSecret = self::getClientSecret();
		if ($verbose) {
			echo "Refresh token: $refreshToken\n";
		}
		if ($clientId && $clientSecret && $refreshToken) {
			if ($verbose) {
				echo "All required request components present. Proceeding.\n";
			}
			// Only continue if all required components are present
			$url = "https://api.dropboxapi.com/oauth2/token";
			$data = http_build_query(array(
				'grant_type' => 'refresh_token',
				'refresh_token' => $refreshToken
			));
			$headers = array(
				"Content-Type: application/x-www-form-urlencoded"
			);
			$user = "$clientId:$clientSecret";

			$decodedResponse = json_decode(Curl::post($url, $data, $headers, $user));

			if ($decodedResponse && $decodedResponse->access_token) {
				return self::saveAccessToken($decodedResponse);
			}
		}
	}

	private static function accessTokenValid($verbose=false) {
		$expiration = self::getAccessTokenExpiration();
		if ($verbose) {
			$currentTimestamp = time();
			echo "Current timestamp: $currentTimestamp | Expiration: $expiration\n";
		}
		if (time() < $expiration) {
			if ($verbose) {
				echo "Not expired\n";
			}
			return true;
		}
		else {
			if ($verbose) {
				echo "Expired\n";
			}
			return false;
		}
	}

	private static function saveAccessToken($tokenData) {
		// Calculate token expiration
		$tokenLifetime = (int)$tokenData->expires_in - 60; // Shave one minute off the life time to give buffer for refresh if needed
		$expires = time() + $tokenLifetime; // Get the expiration timestamp

		// Create and encode token data
		$accessTokenData = new stdClass;
		$accessTokenData->accessToken = $tokenData->access_token;
		$accessTokenData->expires = $expires;
		$accessTokenData->tokenType = $tokenData->token_type;
		$encoded = json_encode($accessTokenData);

		// Save access token
		$filename = self::$accessTokenFileName;
		$file = __DIR__ . "/keys/$filename";
		return file_put_contents($file, $encoded);
	}

	public static function getAppDetails() {
		$fileName = self::$appDetailsFileName;
		$rawDetails = trim(file_get_contents(__DIR__ . "/keys/$fileName"));
		$parsed = json_decode($rawDetails);
		return $parsed;
	}

	public static function getClientId() {
		$details = self::getAppDetails();
		return $details->clientId;
	}
	public static function getClientSecret() {
		$details = self::getAppDetails();
		return $details->clientSecret;
	}
	private static function getAuthorizationCode() {
		$details = self::getAppDetails();
		if ($details->authorizationCode) {
			return $details->authorizationCode;
		}
		else {
			return null;
		}
	}
	private static function getRefreshToken() {
		$fileName = self::$refreshTokenFileName;
		$fileData = json_decode(trim(file_get_contents(__DIR__ . "/keys/$fileName")));
		return $fileData->refreshToken;
	}
	private static function getAccessTokenData() {
		$fileName = self::$accessTokenFileName;
		$fileData = json_decode(trim(file_get_contents(__DIR__ . "/keys/$fileName")));
		return $fileData;
	}
	private static function getAccessToken() {
		$data = self::getAccessTokenData();
		return $data->accessToken;
	}
	private static function getAccessTokenExpiration() {
		$data = self::getAccessTokenData();
		if ($data->expires) {
			return (int)$data->expires;
		}
		else {
			return 0;
		}
	}
}

?>
