<?php

class DropboxAPIController {
	public static function showAuthUrl() {
		$url = DropboxAuth::getAuthUrl();
		$link = "<h3><a href='$url' target='_blank'>Click here to get authorization code</a></h3>";
		$codeInput = "<input class='borderless' id='authorization_code' name='authorization_code' type='text' placeholder='Enter Auth Code From Above Link' />";
		$submitButton = "<button type='submit'>Submit</button>";
		// echo $link;
		$admin = new Admin;
		$title = "Dropbox Authentication";
		$template = $link . "<form method='post' name='authorization_code_form' id='authorization_code_form' action='".CONTROLLER."?m=dropbox_submitAuthCode'>" . $codeInput . $submitButton . "</form>";

		$templateElements = array();

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function submitAuthCode($authCode) {
		$saveResult = DropboxAuth::saveAuthorizationCode($authCode);
		$template = '';
		if ($saveResult === false) {
			$template .= "<h3 style='color: red;'>Saving auth code failed</h3>";
		}
		else {
			$template .= "<h3>Saved auth code</h3>";
		}
		$refreshTokenResult = DropboxAuth::requestRefreshToken();
		if ($refreshTokenResult === false) {
			$template .= "<h3 style='color: red;'>ERROR: Fetching refresh token failed</h3>";
		}
		else {
			$template .= "<h3>Fetched refresh token</h3>";
		}

		$template .= "<h4><a href='".CONTROLLER."?m=dropbox_getAuthUrl'>Redo authentication</a></h4>";
		$template .= "<h4><a href='".CONTROLLER."'>Return to home</a></h4>";

		$admin = new Admin;
		$title = "Dropbox Authentication Result";
		$templateElements = array();

		echo $admin->parse(TEMPLATE, array('BODY' => $admin->parse($template, $templateElements), "TITLE" => $title));
	}

	public static function getRefreshTokenTest() {
		DropboxAuth::requestRefreshToken();
	}

	public static function refreshAccessTokenTest() {
		DropboxAuth::refreshAccessToken(true);
	}

	public static function testFileUpload() {
		$pathToLocalFile = __DIR__ . "/tmp/arduino-1.8.13-macosx.zip";
		$fileName = "arduino-1.8.13-macosx.zip";
		$result = DropboxUpload::upload($fileName, '', true);
		return true;
	}

	public static function uploadDailyBackup($fileName, $verbose=false) {
		$dateStamp = substr($fileName, 0, 6);
		$filePath = "/var/mariadb/backup/$dateStamp/$fileName";
		if ($verbose) {
			echo "Preparing to upload $fileName\nDerived path: $filePath\n";
		}
		$result = DropboxUpload::upload($fileName, $filePath, $verbose);
	}

	public static function getAppDetails() {
		$rawDetails = trim(file_get_contents(__DIR__ . "/keys/appDetails.txt"));
		$parsed = json_decode($rawDetails);
		return $parsed;
	}

	private static function getAppData() {
		$clientId = DropboxAuth::getClientId();
		$clientSecret = DropboxAuth::getClientSecret();
		$accesstoken = DropboxAuth::getValidAccessToken();
		$appData = new stdClass;
		$appData->clientId = $clientId;
		$appData->clientSecret = $clientSecret;
		$appData->accessToken = $accessToken;
		return $appData;
	}

	private static function getClientId() {
		$details = self::getAppDetails();
		return $details->clientId;
	}
	private static function getClientSecret() {
		$details = self::getAppDetails();
		return $details->clientSecret;
	}
}

?>
