<?php

class ConstantContactAPI {
	private static $timeDelay=0.3; // In order to stay under rate limit of 4 per second

	private static $baseURL = 'https://api.cc.email/v3';
	private static $apiKey = '29d06251-8c4c-4d9f-a059-5a4120421e76';
	private static $secret = 'DAY6rEfD1ZPL4fq_6RbG8A';
	private static $redirectBase = array(
		'DEV' => 'http://localhost/',
		'PROD' => 'https://macservice.com/'
	);
	private static $redirectRoute = 'admin_controller.php?m=constantContactAuthVerify';

	public static function getContactsCollection($parameterArray) {
		$url = self::getURL('contacts') . self::getParameterString($parameterArray);
		$accessToken = self::fetchAccessToken();

		$headers = array(
			"Authorization: Bearer $accessToken",
			"Accept: application/json",
			"Content-Type: application/json"
		);

		$contacts = array();
		$result = Curl::get($url, $headers);
		$decodedResult = json_decode(
			substr(
				$result, strpos(
					$result, '{'
					)
				)
			);
		foreach ($decodedResult->contacts as $contact) {
			array_push($contacts, $contact);
		}

		$maxIterations = 10;
		$iterations = 0;
		while ($iterations < $maxIterations && $decodedResult->_links && $decodedResult->_links->next) {
			usleep(self::getTimeDelayMicroseconds());
			$url = "https://api.cc.email" . $decodedResult->_links->next->href;
			$accessToken = self::fetchAccessToken();
			$headers = array(
				"Authorization: Bearer $accessToken",
				"Accept: application/json",
				"Content-Type: application/json"
			);
			$result = Curl::get($url, $headers);
			$decodedResult = json_decode(
				substr(
					$result, strpos(
						$result, '{'
						)
					)
				);
			foreach ($decodedResult->contacts as $contact) {
				array_push($contacts, $contact);
			}
			$iterations++;
		}

		return $contacts;
	}

	public static function getAuthLink() {
		$redirectURI = urlencode(self::getRedirectURI());
		$clientId = self::getApiKey();

		$authURL = self::getAuthorizationURL($redirectURI, $clientId);
		return $authURL;
		// echo "<a href='$authURL' target='_blank'>Auth test link</a>";
	}

	public static function verifyAuthCode($code) {
		$redirectURI = urlencode(self::getRedirectURI());
		$clientId = self::getApiKey();
		$clientSecret = self::getSecret();
		$accessTokenResult = self::getAccessToken($redirectURI, $clientId, $clientSecret, $code);


		$response = (object)json_decode($accessTokenResult);

		if ($response->token_type && $response->token_type == 'Bearer') {
			$accessToken = $response->access_token;
			$refreshToken = $response->refresh_token;
			return self::saveAuthToken($accessToken, $refreshToken);
		}
		else {
			return null;
		}
	}

	/**
	 * @param $redirectURI - URL Encoded Redirect URI
	 * @param $clientId - API Key
	 * @return string - Full Authorization URL
	 */
	private static function getAuthorizationURL($redirectURI, $clientId) {
		// Create authorization URL
		$baseURL = self::getURL('idfed');
		$authURL = $baseURL . "?client_id=" . $clientId . "&redirect_uri=" . $redirectURI . "&scope=contact_data+campaign_data+account_read+account_update&response_type=code";

		return $authURL;
	}

	public static function refreshToken() {
		$refreshToken = self::fetchRefreshToken();
		$clientId = self::getApiKey();
		$clientSecret = self::getSecret();

		$url = 'https://idfed.constantcontact.com/as/token.oauth2?grant_type=refresh_token&refresh_token=' . $refreshToken;

		// Make string of "API_KEY:SECRET"
		$auth = $clientId . ':' . $clientSecret;
		// Base64 encode it
		$credentials = base64_encode($auth);
		// Create and set the Authorization header to use the encoded credentials
    	$authorization = 'Authorization: Basic ' . $credentials;
		$headers = array($authorization);

		$response = (object)json_decode(Curl::post($url, null, $headers));

		if ($response->token_type && $response->token_type == 'Bearer') {
			$accessToken = $response->access_token;
			$refreshToken = $response->refresh_token;
			$saveResult = self::saveAuthToken($accessToken, $refreshToken);
			if ($saveResult) {
				return $accessToken;
			}
			else {
				return null;
			}
		}
		else {
			return null;
		}
	}

	/**
	 * @param $redirectURI - URL Encoded Redirect URI
	 * @param $clientId - API Key
	 * @param $clientSecret - API Secret
	 * @param $code - Authorization Code
	 * @return string - JSON String of results
	 */
	private static function getAccessToken($redirectURI, $clientId, $clientSecret, $code) {
		// Use cURL to get access token and refresh token
		$ch = curl_init();

		// Define base URL
		$base = 'https://idfed.constantcontact.com/as/token.oauth2';

		// Create full request URL
		$url = $base . '?code=' . $code . '&redirect_uri=' . $redirectURI . '&grant_type=authorization_code&scope=contact_data';
		curl_setopt($ch, CURLOPT_URL, $url);

		// Set authorization header
		// Make string of "API_KEY:SECRET"
		$auth = $clientId . ':' . $clientSecret;
		// Base64 encode it
		$credentials = base64_encode($auth);
		// Create and set the Authorization header to use the encoded credentials
		$authorization = 'Authorization: Basic ' . $credentials;
		curl_setopt($ch, CURLOPT_HTTPHEADER, array($authorization));

		// Set method and to expect response
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Make the call
		$result = curl_exec($ch);
		curl_close($ch);
		return $result;
	}

	private static function saveAuthToken($accessToken, $refreshToken) {
		$tokenData = array(
			"access_token" => $accessToken,
			"refresh_token" => $refreshToken,
			"expires" => time() + (2 * 60 * 60) // 2 hours
		);

		$tokenPath = self::getAuthTokenPath();
		try {
			if (!file_exists($tokenPath)) {
				mkdir($tokenPath, 0777, true);
			}

		}
		catch (Exception $e) {
			echo $e;
		}
		$result = file_put_contents($tokenPath, json_encode($tokenData));
		return $result;
	}

	private static function fetchAccessToken() {
		$accessTokenPath = self::getAccessTokenPath();
		$response = (object)json_decode(file_get_contents($accessTokenPath));
		if ($response->access_token) {
			$accessToken = null;
			if (time() >= (int)$response->expires) {
				$accessToken = self::refreshToken();
			}
			else {
				$accessToken = $response->access_token;
			}
			return $accessToken;
		}
		else {
			return null;
		}
	}
	private static function fetchRefreshToken() {
		$refreshTokenPath = self::getRefreshTokenPath();
		$response = (object)json_decode(file_get_contents($refreshTokenPath));
		if ($response->refresh_token) {
			return $response->refresh_token;
		}
		else {
			return null;
		}
	}
	private static function getAuthTokenPath() {
		return HTML_FOLDER . "apis/constantContact/keys/authToken.txt";
	}
	private static function getAccessTokenPath() {
		// return HTML_FOLDER . "apis/constantContact/keys/accessToken.txt";
		return self::getAuthTokenPath();
	}
	private static function getRefreshTokenPath() {
		// return HTML_FOLDER . "apis/constantContact/keys/refreshToken.txt";
		return self::getAuthTokenPath();
	}
	private static function getRedirectURI() {
		return self::$redirectBase[MODE] . self::$redirectRoute;
	}
	private static function getParameterString($parameterArray) {
		return '?' . http_build_query($parameterArray);
	}
	private static function getURL($method) {
		if (substr($method, 0, 1) != '/') {
			$method = "/" . $method;
		}
		return self::getBaseURL() . $method;
	}
	private static function getBaseURL() {
		return self::$baseURL;
	}
	private static function getApiKey() {
		return self::$apiKey;
	}
	private static function getSecret() {
		return self::$secret;
	}
	private static function getTimeDelayMicroseconds() {
		return self::getTimeDelay() * 1000000;
	}
	private static function getTimeDelay() {
		return self::$timeDelay;
	}
}

?>
