<?php

class BackmarketAPI extends Database {
	private $urlBase = array(
		'PROD' => 'https://www.backmarket.com/ws/',
		'DEV' => 'https://www.backmarket.com/ws/'
	);

	private $token = "ai5zYW5kZXJzb25AdGVjaHRvc2Nob29sLmNvbTp6eWtnYWYtd3V4WGV6LXJheHp5Mw==";

	private $accessKey = "9de26228fd99a5a3365568";
	private $securityKey = "BMT-7066776d6fee9dbf73da893beb7b242d1baf05a6";
	private $userAgent = 'SourcePlus';

	public function getAllUnfulfilledOrders() {
		// Order States:
		// 0 - New Order Payment validation is pending. We are doing verifications to check the customer identity. The `Orders` in this `State` must not be shipped.
		// 1 - Payment is checked & validated. The merchant has to process (accept or cancel) the `Orderlines`.
		// 3 - `Order` shipping is pending. The payment and the `Order` (all `Orderlines`) have been validated. The merchant has to ship the package to the customer.
		// 8 - Order is not paid. Payment process has failed, the merchant must ignore this `Order`.
		// 9 - Order processed. The merchant has shipped the package.

		// States for Orderlines
		// 0 - New `Orderline`. The merchant has to wait for payment confirmation.
		// 1 - `Orderline` is paid. The merchant has received the payment and must validate or cancel the `Orderline`.
		// 2 - `Orderline` is accepted by the merchant, who must now prepare the `Product` for shipment.
		// 3 - The merchant has deliver the `Orderline` to the shipping company. The package delivery is in progress.
		// 4 - `Orderline` is cancelled. The customer will be refunded for the `Orderline`.
		// 5 - Orderline is refunded before shipping.
		// 6 - Orderline is refunded after shipping. The customer made a refund request.
		// 7 - Orderline is not paid. The payment has been refused by the bank.


		// echo "<h2>New Orders</h2>";
		// $newOrders = json_decode($this->getOrders(0, 50));
		// echo print_r($newOrders);
		// echo "<h2>Awaiting Processing</h2>";
		// $awaitingProcessing = json_decode($this->getOrders(1, 50));
		// echo print_r($awaitingProcessing);
		echo "<h2>Pending Shipping</h2>";
		$pendingShipping = json_decode($this->getOrders(3, 50));
		echo print_r($pendingShipping);
		echo "<h2>Pending Shipping RESULTS ONLY</h2>";
		echo print_r($pendingShipping->results);
		foreach($pendingShipping->results as $result) {
			echo "<p></p>";
			echo print_r($result);
			echo "<p></p>";
			echo $result->order_id;

		}
	}

	public function getOrder($orderId) {
		$url = $this->getUrl('orders') . "/$orderId";
		$headers = $this->getHeaders();

		return $this->curl_get_2($url, $headers);
	}

	public function getSavs($state=null, $page=null) {
		$url = $this->getUrl('sav', $page);
		if ($state !== null) {
			if (strpos($url, '?') === false) {
				$url .= '/?';
			} else {
				$url .= '&';
			}
			$url .= "state=$state";
		}
		$headers = $this->getHeaders();

		return json_decode($this->curl_get_2($url, $headers));
	}

	public function getSav($orderId) {
		$url = $this->getUrl('sav') . "/$orderId";
		$headers = $this->getHeaders();
		return json_decode($this->curl_get_2($url, $headers));
	}

	public function getOrders($state, $pageSize=null) {
		$url = $this->getUrl('orders', null, $pageSize);
		$headers = $this->getHeaders();

		if (strpos($url, '?') === false) {
			$url .= '/?';
		} else {
			$url .= '&';
		}
		$url .= "state=$state";

		return $this->curl_get_2($url, $headers);
	}

	public function shipOrder($data) {
		$orderId = $data['order_id'];
		$orderData = $this->getOrder($orderId);
		if ($orderData) {
			$decodedData = json_decode($orderData);
			if ($decodedData->state == 3) {
				$url = $this->getUrl('orders') . "/$orderId";
				$postData = array(
					"order_id" => (int)$orderId,
					"new_state" => 3,
					"serial_number" => $data['serial_number'],
					"tracking_number" => $data['tracking_number']
				);
				if ($data['shipper'] && $data['shipper'] != '') {
					$postData['shipper'] = $data['shipper'];
				}
				$headers = $this->getHeaders();
				return $this->curl_post_2($url, $postData, $headers);
			}
			else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function validateOrder($orderId) {
		$orderData = $this->getOrder($orderId);
		if ($orderData) {
			$decodedData = json_decode($orderData);
			$newState = $decodedData->orderlines[0]->state + 1;
			$url = $this->getUrl('orders') . "/$orderId";
			$headers = $this->getHeaders();
			$postData = array(
				"order_id" => (int)$orderId,
				"new_state" => $newState
			);
			foreach ($decodedData->orderlines as $orderline) {
				$sku = $orderline->listing;
				$postData['sku'] = $sku;
				$this->curl_post_2($url, $postData, $headers);
			}
			return true;
		}
		return false;
	}

	public function cancelOrder($orderId) {
		$orderData = $this->getOrder($orderId);
		if ($orderData) {
			$decodedData = json_decode($orderData);
			$newState = $decodedData->orderlines[0]->state + 3;
			$url = $this->getUrl('orders') . "/$orderId";
			$headers = $this->getHeaders();
			$postData = array(
				"order_id" => (int)$orderId,
				"new_state" => $newState
			);
			foreach ($decodedData->orderlines as $orderline) {
				$sku = $orderline->listing;
				$postData['sku'] = $sku;
				$this->curl_post_2($url, $postData, $headers);
			}
			return true;
		}
		return false;
	}

	public function getOrderHistory() {
		$url = $this->getUrl('orders', 0, 50);
		$url .= "&state=9";
		$headers = $this->getHeaders();
		$orders = $this->curl_get_2($url, $headers);
		// echo $orders;
		$decodedOrders = json_decode($orders);

		$results = $decodedOrders->results;
		$nextUrl = $decodedOrders->next;
		while($nextUrl) {
			$newOrders = $this->curl_get_2($nextUrl, $headers);
			$decodedNewOrders = json_decode($newOrders);
			// echo "<p>$nextUrl</p>";
			$nextUrl = $decodedNewOrders->next;
			$newResults = $decodedNewOrders->results;
			$results = array_merge($results, $newResults);
		}
		// echo "<pre>";
		// print_r($results);
		// echo "</pre>";
		// foreach ($results as $result) {
		// 	if ($result->orderlines[0]->state == 6) {
		// 		echo "<pre>";
		// 		print_r($result);
		// 		echo "</pre>";
		// 	}
		// }
		// echo $decodedOrders->next;
		// echo "<p></p>";
		// echo print_r($results);
		return $results;
	}

	/**
	 * Builds the url to call for data.
	 *
	 * @param string $module - The module to call from. For example, 'orders'
	 * @param int $page - The page to call from.
	 * @param int $pageSize - Number of records per page. Max 50.
	 *
	 * @return string
	 *
	 */
	private function getUrl($module, $page=null, $pageSize=null) {
		$url = $this->urlBase[MODE] . $module;
		if ($page) {
			$url .= "/?page=$page";
		}
		if ($pageSize) {
			if ($page) {
				$url .= "&";
			} else {
				$url .= "/?";
			}
			$url .= "page-size=$pageSize";
		}
		return $url;
	}

	private function getHeaders() {
		$userAgent = $this->getUserAgent();
		$token = $this->getToken();
		return array(
			"Accept-Language: en-us",
			"Content-type: application/json",
			"Accept: application/json",
			"User-Agent: $userAgent",
			"Authorization: Basic $token"
		);
	}

	private function getUserAgent() {
		return $this->userAgent;
	}

	private function getToken() {
		return $this->token;
	}

	function isBackMarketOrder($orderNum) {
		return preg_match('/^(BM)?\d{6,7}$/', $orderNum);
	}

	public function getChannelId() {
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='back_market' LIMIT 1";
		$result = $this->db_query($sql, 'select-single', true);
		if (!$result['id']) {
			$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='backmarket' LIMIT 1";
			$result = $this->db_query($sql, 'select-single', true);
		}
		return $result['id'];
	}

	public function getEcommId($orderId) {
		$channelId = $this->getChannelId();
		$sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['id'];
	}
}
