<?php
require 'RequestSigner.php';
// require 'STS/STSHelper.php';
require HTML_FOLDER . "vendor/autoload.php";

// use Aws\Signature\SignatureProvider;
use Aws\Sts\StsClient;
use Aws\AwsClient;
use Aws\Exception\AwsException;
use Aws\Credentials\Credentials;
use Aws\Signature\SignatureProvider;

class AmazonAPI extends Database {

	const GET = 'GET';
	private $rootPath = '';
	private $clientIdentifier = '';
	private $clientSecret = '';
	private $token;
	private $tokenExpires;

	private $stsCredentials;

	private $developerId = '118715656849';
	private $marketplaceId = 'ATVPDKIKX0DER';

	private $credentials;

	private $endpoint;
	private $paths = array(
		'getOrders' => array('path' => '/orders/v0/orders', 'method' => 'GET'),
		'inventory' => array('path' => '/fba/inventory/v1/summaries', 'method' => 'GET'),
		'listCatalogItems' => array('path' => '/catalog/v0/items', 'method' => 'GET'),
		'getMarketplaceParticipations' => array('path' => '/sellers/v1/marketplaceParticipations', 'method' => 'GET')
	);

	private $apiName = 'SourcePlus';
	private $apiVersion = '0.1';


	private $debug = false;
	private $sandbox = false;

	public function __construct($version='v2', $sandbox=false, $debug=false) {
		if ($sandbox) {
			$this->endpoint = "https://sandbox.sellingpartnerapi-na.amazon.com";
		}
		else {
			$this->endpoint = 'https://sellingpartnerapi-na.amazon.com';
		}
		$this->rootPath = __DIR__ . '/';
		$this->sandbox = $sandbox;
		$this->debug = $debug;
		$this->clientIdentifier = $this->getClientIdentifier($version);
		$this->clientSecret = $this->getClientSecret($version);
		$this->token = $this->getAccessToken();
		$this->stsCredentials = $this->getStsToken();
		// $provider = SignatureProvider::defaultProvider();
		// $awsClient = new AwsClient([
		// 	'version' => 'latest',
		// 	'region' => 'us-east-1',
		// 	'signer' => SignatureProvider::resolve($provider, 'v4', 'execute-api', 'us-east-1'),
		// 	'credentials' => $this->getStsToken(),
		// ]);
		// $awsClient->getSignatureProvider();
		$this->tokenExpires = $this->getAccessTokenExpirationTimestamp();
	}

	/**************************
	 * PUBLIC FUNCTIONS BEGIN *
	 **************************/

	/**
	 * API test function for testing functionality of API
	 */
	public function apiTest() {
		// echo "<h1>".STSHelper::createQueryString()."</h1>";
		// $this->getOrders();
		// $this->testRequestSigner();
		// echo "<hr />";
		// $this->getMarketplaceParticipations();
		//$this->testSix();
		//$this->testRequestSigner();
		//	$this->ShippedOrderRequestSigner();
		//$this->OpenOrderRequestSigner();
		$this->getOrderItemsSP('112-7816028-0636201');
	}

	public function getOrders() {
		$url = $this->getUrl('orders');
		$unsignedHeaders = $this->getHeaders();
		if ($this->debug) {
			/*echo "<pre>URL:\n$url\nRequest headers:\n";
			print_r($unsignedHeaders);
			echo "</pre>";*/
		}
		$request = new GuzzleHttp\Psr7\Request('GET', $url, $unsignedHeaders);
		$signedRequest = $this->signer->signRequest($request, $this->credentials);
		$requestHeaders = array();
		foreach ($signedRequest->getHeaders() as $name => $values) {
			array_push($requestHeaders, "$name: " . implode(', ', $values));
		}

		if ($this->debug) {
			/*echo "<pre>Signed URI:\n";
			echo (string)$signedRequest->getUri();
			echo "\nSigned headers:\n";
			print_r($signedRequest->getHeaders());
			echo "</pre>";*/
		}


		$response = $this->curl_get_2($url, $requestHeaders);
		$decodedResponse = json_decode($response);
		if ($this->debug) {
			/*echo "<pre>Raw response:\n$response\nDecoded response:\n";
			print_r($decodedResponse);
			echo "</pre>";*/
		}
	}

	public function getMarketplaceParticipations() {

		$method = GET;
		$uri = $this->getUrl('getMarketplaceParticipations');
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());

		/*echo "<pre>$requestSignerData->canonicalRequest</pre>";
		echo "<pre>$requestSignerData->stringToSign</pre>";*/

		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		// $signedRequestHeaders['X-Amz-Security-Token'] = $this->stsToken;
		$stsToken = $this->stsCredentials['token'];
		// echo "<h1>STS Token: $stsToken</h1>";
		array_push($signedRequestHeaders, "x-amz-security-token: $stsToken");
		/*echo "<h4>Sending request to URL $uri using the following headers:</h4>";
		echo "<pre>";
		print_r($signedRequestHeaders);
		echo "</pre>";*/
		$response = $this->curl_get_2($uri, $signedRequestHeaders);
		$decodedResponse = json_decode($response);
		/*echo "<h2>Response data:</h2>";
		echo "<pre>Raw response:\n$response\nDecoded response:\n";
		print_r($decodedResponse);
		echo "</pre>";*/
	}

	public function getInventory() {
		$method = GET;
		$uri = $this->getUrl('inventory');
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());

		/*echo "<pre>$requestSignerData->canonicalRequest</pre>";
		echo "<pre>$requestSignerData->stringToSign</pre>";*/

		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$response = $this->curl_get_2($uri, $signedRequestHeaders);
		$decodedResponse = json_decode($response);
		/*echo "<h2>Response data:</h2>";
		echo "<pre>Raw response:\n$response\nDecoded response:\n";
		print_r($decodedResponse);
		echo "</pre>";*/
	}

	public function testListCatalogItems() {
		$method = GET;
		$uri = $this->getUrl('listCatalogItems');
		$uri .= "?MarketplaceId=$this->marketplaceId";
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		/*echo "<h4>Sending request to URL $uri using the following headers:</h4>";
		echo "<pre>";
		print_r($signedRequestHeaders);
		echo "</pre>";*/
		$response = $this->curl_get_2($uri, $signedRequestHeaders);
		$decodedResponse = json_decode($response);
		/*echo "<h2>Response data:</h2>";
		echo "<pre>Raw response:\n$response\nDecoded response:\n";
		print_r($decodedResponse);
		echo "</pre>";*/
	}
	public function OrderRequestSigner($orderNumbers=null) {
		if (!$orderNumbers) {
			return '';
		}
		$method = GET;
		$uri = $this->getUrl('getOrders')."/".$orderNumbers;
		/*$uri .= "?MarketplaceIds=$this->marketplaceId";
		$uri .= "&CreatedAfter=2023-05-31";*/
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		// $requestHeaders = implode("\n",$signedRequestHeaders);
		$requestHeaders = $signedRequestHeaders;
		$response = $this->curl_get_2($uri, $requestHeaders);
		$decodedResponse = json_decode($response,true);
		// $payload_response = $decodedResponse['payload'];
		// $order_response = $payload_response['Orders'];
		
		// return json_decode(json_encode($order_response, TRUE));
		return $decodedResponse;
	}

	public function testRequestSigner() {
		$method = GET;
		$uri = $this->getUrl('getOrders')."?MarketplaceIds=$this->marketplaceId&CreatedAfter=2023-05-31&OrderStatuses=Pending,Unshipped,PartiallyShipped";
		/*$uri .= "?MarketplaceIds=$this->marketplaceId";
		$uri .= "&CreatedAfter=2023-05-31";*/
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		// $requestHeaders = implode("\n",$signedRequestHeaders);
		$requestHeaders = $signedRequestHeaders;
		$response = $this->curl_get_2($uri, $requestHeaders);
		$decodedResponse = json_decode($response,true);
		$payload_response = $decodedResponse['payload'];
		$order_response = $payload_response['Orders'];
		$order_response_array = [];
		foreach( $order_response as $order_responses) {
			$order_status = $order_responses['OrderStatus'];
			//if($order_status == 'Unshipped' || $order_status == 'Pending' || $order_status == 'Partially Shipped' ) {
				$buyer_uri = $this->getUrl('getOrders')."/".$order_responses['AmazonOrderId']."/buyerInfo/?MarketplaceIds=$this->marketplaceId";
				$buyer_requestSigner = new RequestSigner($method, $buyer_uri, $headers, $payload, $credentialScope);
				$buyer_requestSignerData = $buyer_requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
				$buyer_signedRequestHeaders = $buyer_requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
				$buyer_requestHeaders = $buyer_signedRequestHeaders;
				$buyer_response = $this->curl_get_2($buyer_uri, $buyer_requestHeaders);
				$buyer_decodedResponse = json_decode($buyer_response,true);
				$buyer_payload_response = $buyer_decodedResponse['payload'];
				$order_responses['BuyerInfo']['BuyerName'] = $buyer_payload_response['BuyerName'];
				array_push($order_response_array,$order_responses);

			//}
		}
		/*echo "order test" . $buyer_uri;
		echo "<pre>";
		print_r($order_response_array);
		echo "</pre>";*/
		return json_decode(json_encode($order_response_array, TRUE));
	}
	
	public function OpenOrderRequestSigner() {
		$method = GET;
		//$uri = $this->getUrl('getOrders')."?MarketplaceIds=$this->marketplaceId&CreatedAfter=2023-05-31&OrderStatuses=Pending,Unshipped,PartiallyShipped";
		$uri = $this->getUrl('getOrders')."?MarketplaceIds=$this->marketplaceId&CreatedAfter=2023-10-25&OrderStatuses=Pending,Unshipped,PartiallyShipped";
		/*$uri .= "?MarketplaceIds=$this->marketplaceId";
		$uri .= "&CreatedAfter=2023-05-31";*/
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		// $requestHeaders = implode("\n",$signedRequestHeaders);
		$requestHeaders = $signedRequestHeaders;
		$response = $this->curl_get_2($uri, $requestHeaders);
		$decodedResponse = json_decode($response,true);
		$payload_response = $decodedResponse['payload'];
		$order_response = $payload_response['Orders'];
		$order_response_array = [];
		foreach( $order_response as $order_responses) {
			$order_status = $order_responses['OrderStatus'];
			//if($order_status == 'Unshipped' || $order_status == 'Pending' || $order_status == 'Partially Shipped' ) {
				$buyer_uri = $this->getUrl('getOrders')."/".$order_responses['AmazonOrderId']."/buyerInfo/?MarketplaceIds=$this->marketplaceId";
				$buyer_requestSigner = new RequestSigner($method, $buyer_uri, $headers, $payload, $credentialScope);
				$buyer_requestSignerData = $buyer_requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
				$buyer_signedRequestHeaders = $buyer_requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
				$buyer_requestHeaders = $buyer_signedRequestHeaders;
				$buyer_response = $this->curl_get_2($buyer_uri, $buyer_signedRequestHeaders);
				$buyer_decodedResponse = json_decode($buyer_response,true);
				$buyer_payload_response = $buyer_decodedResponse['payload'];
				$order_responses['BuyerInfo']['BuyerName'] = $buyer_payload_response['BuyerName'];
				array_push($order_response_array,$order_responses);
			//}
		}
		/*echo "<pre>";
		print_r($order_response_array);
		echo "</pre>";*/
		return json_decode(json_encode($order_response_array, TRUE));
	}
	
	public function canceledOrderRequestSigner() {
		$method = GET;
		$uri = $this->getUrl('getOrders')."?MarketplaceIds=$this->marketplaceId&CreatedAfter=".date('Y-m-d', strtotime('-10 days'))."&OrderStatuses=Canceled";
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		// $requestHeaders = implode("\n",$signedRequestHeaders);
		$requestHeaders = $signedRequestHeaders;
		$response = $this->curl_get_2($uri, $requestHeaders);
		$decodedResponse = json_decode($response,true);
		$payload_response = $decodedResponse['payload'];
		$order_response = $payload_response['Orders'];
		$order_response_array = [];
		foreach( $order_response as $order_responses) {
			$order_status = $order_responses['OrderStatus'];
			//if($order_status == 'Unshipped' || $order_status == 'Pending' || $order_status == 'Partially Shipped' ) {
				$buyer_uri = $this->getUrl('getOrders')."/".$order_responses['AmazonOrderId']."/buyerInfo/?MarketplaceIds=$this->marketplaceId";
				$buyer_requestSigner = new RequestSigner($method, $buyer_uri, $headers, $payload, $credentialScope);
				$buyer_requestSignerData = $buyer_requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
				$buyer_signedRequestHeaders = $buyer_requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
				$buyer_requestHeaders = $buyer_signedRequestHeaders;
				$buyer_response = $this->curl_get_2($buyer_uri, $buyer_signedRequestHeaders);
				$buyer_decodedResponse = json_decode($buyer_response,true);
				$buyer_payload_response = $buyer_decodedResponse['payload'];
				$order_responses['BuyerInfo']['BuyerName'] = $buyer_payload_response['BuyerName'];
				array_push($order_response_array,$order_responses);
			//}
		}
		return json_decode(json_encode($order_response_array, TRUE));
	}
	
	public function getAmazonChannelIdSP() {
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='amazon' LIMIT 1";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['id'];
	}
	
	public function getOrderItemsSP($orderId) {
		//echo "orderId => <br>".$orderId;
		$method = GET;
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$prod_uri = "https://sellingpartnerapi-na.amazon.com/orders/v0/orders/".$orderId."/orderItems/";
		//$prod_uri = "https://sellingpartnerapi-na.amazon.com/orders/v0/orders/114-4203921-7223432/orderItems/";
		$prod_requestSigner = new RequestSigner($method, $prod_uri, $headers, $payload, $credentialScope);
		$prod_requestSignerData = $prod_requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$prod_signedRequestHeaders = $prod_requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$prod_requestHeaders = $prod_signedRequestHeaders;
		$prod_response = $this->curl_get_2($prod_uri, $prod_requestHeaders);
		$prod_decodedResponse = json_decode($prod_response,true);
		$prod_payload_response = $prod_decodedResponse['payload'];
		$orderItem_data = $prod_payload_response['OrderItems'];
		$orderItemData = array();
		if (is_array($orderItem_data)) {
			$orderItems = json_decode(json_encode($orderItem_data,true));
			foreach ($orderItems as $orderItem) {
				$itemData = new stdClass;
				$itemData->itemId = $orderItem->ASIN;
				$itemData->sku = $orderItem->SellerSKU;
				$itemData->title = $orderItem->Title;
				$itemData->quantity = $orderItem->QuantityOrdered;
				$itemData->price = $orderItem->ItemPrice->Amount;
				//$orderItemData[$itemData->OrderItemId] = $itemData;
				if ($orderItemData[$orderItem->ASIN]) {
					$orderItemData[$orderItem->ASIN]->quantity += $orderItem->QuantityOrdered;
				}
				else {
					$itemData = new stdClass;
					$itemData->itemId = $orderItem->ASIN;
					$itemData->sku = $orderItem->SellerSKU;
					$itemData->title = $orderItem->Title;
					$itemData->quantity = $orderItem->QuantityOrdered;
					$itemData->price = $orderItem->ItemPrice->Amount;
					$orderItemData[$itemData->OrderItemId] = $itemData;
				}
			}
		} else {
			$orderItemData = "You Exceeded your Quota for the requested resource";
		}		
		return $orderItemData;
	}
	
	public function ShippedOrderRequestSigner() {
		$method = GET;
		$uri = $this->getUrl('getOrders')."?MarketplaceIds=$this->marketplaceId&CreatedAfter=2023-09-18";
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$requestSignerData = $requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$signedRequestHeaders = $requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$requestHeaders = $signedRequestHeaders;
		$response = $this->curl_get_2($uri, $requestHeaders);
		$decodedResponse = json_decode($response,true);
		$payload_response = $decodedResponse['payload'];
		$order_response = $payload_response['Orders'];
		
		$order_resp = [];
			foreach( $order_response as $order_responses) {
			$prod_uri = $this->getUrl('getOrders')."/".$order_responses['AmazonOrderId']."/orderItems/?MarketplaceIds=$this->marketplaceId&CreatedAfter=2023-09-21";
			$prod_requestSigner = new RequestSigner($method, $prod_uri, $headers, $payload, $credentialScope);
			$prod_requestSignerData = $prod_requestSigner->signRequest($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
			$prod_signedRequestHeaders = $prod_requestSigner->signRequestHeaders($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
			$prod_requestHeaders = $prod_signedRequestHeaders;
			$prod_response = $this->curl_get_2($prod_uri, $prod_requestHeaders);
			$prod_decodedResponse = json_decode($prod_response,true);
			$prod_payload_response = $prod_decodedResponse['payload'];
			$product_response = $prod_payload_response['OrderItems'];
			$prod_resp_array = [];
			$order_status = $order_responses['OrderStatus'];
			if($order_status == 'Shipped' ) {
				$orderData = new stdClass;
				$orderData->AmazonOrderId = $order_responses['AmazonOrderId'];
				$orderData->PurchaseDate = $order_responses['PurchaseDate'];
				$orderData->ShipServiceLevel = $order_responses['ShipServiceLevel'];
				$orderData->ShipDate = $order_responses['EarliestShipDate'];
				$orderItems = $this->getOrderItemsSP($orderData->AmazonOrderId);
				if($orderItems){
					/*echo '<pre>';
					print_r($orderData);
					echo '<pre>';
					print_r($orderItems);*/
					$orderData->OrderTotal = 0;
					foreach ($orderItems as $orderItem) {
						//$orderData->OrderTotal += (float)$orderItem->price;
						$orderData->OrderTotal = $orderData->OrderTotal + $orderItem->price;
					}
				}
				
				echo "OrderTotal =>" . $orderItem->price;
				$channelId = $this->getAmazonChannelIdSP();
				//$sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderData->AmazonOrderId', '$channelId', '$orderData->PurchaseDate', '$orderData->OrderTotal') ON DUPLICATE KEY UPDATE `subtotal`='$orderData->OrderTotal';";
				$sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderData->AmazonOrderId', '$channelId', '$orderData->PurchaseDate', '$orderItem->price') ON DUPLICATE KEY UPDATE `subtotal`='$orderItem->price';";
				$this->db_query($sql, 'insert', true);
				
				$orderData->Query = $sql;

				$sql = "INSERT IGNORE INTO `ecomm_shipping_details`(`ecomm_id`, `ship_date`, `ship_method`) VALUES ((SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderData->AmazonOrderId'), '$orderData->ShipDate', '$orderData->ShipServiceLevel');";
				$this->db_query($sql, 'insert', true);

				foreach ($orderItems as $orderItem) {
					$title = mysql_real_escape_string($orderItem->title);
					$sql = "INSERT IGNORE INTO `ecomm_amazon_listings`(`sku`, `order_item_id`, `title`) VALUES ('$orderItem->sku', '$orderItem->itemId', '$title');";
					$this->db_query($sql, 'insert', true);
					$this->resetAutoIncrement('ecomm_amazon_listings');
					$sql = "INSERT IGNORE INTO `ecomm_amazon_listings_shipped`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `ecomm_amazon_listings` WHERE `order_item_id` = '$orderItem->itemId'), (SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderData->AmazonOrderId'),'$orderItem->quantity');";
					$this->db_query($sql, 'insert', true);
				}

				$orderData->OrderItems = $orderItems;

				array_push($order_resp, $orderData);
			}
		}
		
		/* echo "<pre>";
		print_r($order_resp);
		echo "</pre>"; */
		return json_decode(json_encode($order_resp, TRUE));
		//return json_encode($order_resp,true);
		return $order_resp;
	}

	public function testSix() {
		$method = GET;
		$uri = $this->getUrl('getMarketplaceParticipations');
		$uri .= "?MarketplaceIds=$this->marketplaceId";
		$headers = $this->getHeaders();
		$payload = '';
		$credentialScope = $this->getCredentialScope();
		$requestSigner = new RequestSigner($method, $uri, $headers, $payload, $credentialScope);
		$accessKeyId = $this->stsCredentials['key'];
		$secretKey = $this->stsCredentials['secret'];
		$token = $this->stsCredentials['token'];
		$requestSignerData = $requestSigner->signRequest($accessKeyId, $secretKey);
		$signedRequestHeaders = $requestSigner->signRequestHeaders($accessKeyId, $secretKey);
		// array_push($signedRequestHeaders, "x-amz-security-token: $token");
		/*echo "<pre>Request signer data:";
		print_r($requestSignerData);
		echo "</pre>";*/
		$response = $this->curl_get_2($uri, $signedRequestHeaders);
		$decodedResponse = json_decode($response);
		/*echo "<h2>Response data:</h2>";
		echo "<pre>Raw response:\n$response\nDecoded response:\n";
		print_r($decodedResponse);
		echo "</pre>";*/
	}

	/************************
	 * PUBLIC FUNCTIONS END *
	 ************************/

	private function getUrl($model, $pathParameters=null, $queryParameters=null) {
		return $this->endpoint . $this->paths[$model]['path'];
	}

	private function getCredentialScope($region='us-east-1', $service='execute-api') {
		$date = date_format(new DateTime('now', new DateTimeZone('UTC')), 'Ymd');
		$credentialScope = new stdClass;
		$credentialScope->date = $date;
		$credentialScope->region = $region;
		$credentialScope->service = $service;
		$credentialScope->terminationString = 'aws4_request';
		return $credentialScope;
		// return "$date/us-east-1/execute-api/aws4_request";
	}

	private function getAwsUserAccessKeyId() {
		return trim(file_get_contents($this->rootPath . 'keys/aws/api_user/access_key_id.txt'));
	}
	private function getAwsUserSecretAccessKey() {
		return trim(file_get_contents($this->rootPath . 'keys/aws/api_user/secret_access_key.txt'));
	}

	/**
	 * Gets client identifier from storage
	 */
	private function getClientIdentifier($version='v2') {
		return trim(file_get_contents($this->rootPath . "keys/application/$version/client_identifier.txt"));
	}

	/**
	 * Gets client secret from storage
	 */
	private function getClientSecret($version='v2') {
		return trim(file_get_contents($this->rootPath . "keys/application/$version/client_secret.txt"));
	}

	/**
	 * Gets token access path
	 */
	private function getAccessTokenPath() {
		$url = 'https://api.amazon.com/auth/o2/token';
		$requestHeaders = array(
			'Host' => 'api.amazon.com',
			'Content-Type' => 'application/x-www-form-urlencoded;charset=UTF-8'
		);
		$requestData = "user_code=AAYJHL&device_code=B66fd882-7405-4e9a-bfb9&grant_type=device_code";
		//return $this->rootPath . "keys/lwa_token.txt";
	}

	/**
	 * Gets refresh token
	 */
	private function getRefreshToken() {
		if ($this->debug) {
			/*echo "<pre>";
			echo "Refresh token:\n";
			echo file_get_contents($this->rootPath . 'keys/refresh_token.txt');
			echo "</pre>";*/
		}
		return trim(file_get_contents($this->rootPath . 'keys/refresh_token.txt'));
	}

	/**
	 * Called when token is expired. Generates a new access token, stores it in lwa_token.txt, then returns the new access token to the calling function.
	 */
	private function getFreshAccessToken() {
		$url = 'https://api.amazon.com/auth/o2/token';
		$refreshToken = $this->getRefreshToken();
		$requestHeaders = array(
			'Host' => 'api.amazon.com',
			'Content-Type' => 'application/x-www-form-urlencoded;charset=UTF-8'
		);
		//$requestData = "grant_type=refresh_token&refresh_token=$refreshToken&client_id=$this->clientIdentifier&client_secret=$this->clientSecret";
		$requestData = "grant_type=refresh_token&refresh_token=$refreshToken&client_id=amzn1.application-oa2-client.fe952a093d914c59a736755915465f1a&client_secret=amzn1.oa2-cs.v1.16135501c744ca9d8d7502a3d1f857a5e086ede82705efdcd33b684b8db27b8b";
		if ($this->debug) {
			/*echo "<pre>Request headers:\n";
			print_r($requestHeaders);
			echo "\nRequest data:\n$requestData\nURL:\n$url\n</pre>";*/
		}
		$response = json_decode($this->curl_post_2($url, $requestData, $requestHeaders));
		if ($this->debug) {
			/*echo "<pre>New token response:\n";
			print_r($response);
			echo "</pre>";*/
		}
		if ($response->token_type && $response->token_type == 'bearer') {
			$tokenData = array(
				"access_token" => $response->access_token,
				"expires" => time() + ((int)$response->expires_in - 10)
			);
			$accessTokenPath = $this->getAccessTokenPath();
			try {
				if (!file_exists($accessTokenPath)) {
					mkdir($accessTokenPath, 0700, true);
				}
			}
			catch (Exception $e) {
				//echo $e;
			}
			$result = file_put_contents($accessTokenPath, json_encode($tokenData));
			return $response->access_token;
		}
	}

	/**
	 * Fetches access token for making API calls
	 */
	private function getAccessToken() {
		$tokenData = json_decode(file_get_contents($this->getAccessTokenPath())); // Get access token from storage
		if ($this->isTokenValid($tokenData)) { // Check if the token has expired yet
			return $tokenData->access_token; // If not expired, return token
		}
		else {
			return $this->getFreshAccessToken(); // If expired, get fresh token and return that instead
		}
	}

	/**
	 * Gets token STS path
	 */
	private function getStsTokenPath() {
		return $this->rootPath . "keys/aws/sts/sts_token.txt";
	}

	private function getFreshStsToken() {
		$roleToAssume = trim(file_get_contents($this->rootPath . "keys/aws/api_user_role/api_user_role_arn.txt"));
		$stsCredentials = new Aws\Credentials\Credentials($this->getAwsUserAccessKeyId(), $this->getAwsUserSecretAccessKey());
		$stsClient = new StsClient([
			'version' => 'latest',
			'region' => 'us-east-1',
			'credentials' => $stsCredentials,
		]);
		try {
			$result = $stsClient->assumeRole([
				'RoleArn' => 'arn:aws:iam::905061731603:role/APIUserRole',
				'Action' => 'AssumeRole',
				'Version' => '2011-06-15',
				'RoleSessionName' => 'testsession1',
				'PolicyArns' => [
					[
						'arn' => "arn:aws:iam::905061731603:role/APIUserRole",
					],
				],
			]);
			$credentials = array(
				'key' => $result['Credentials']['AccessKeyId'],
				'secret' => $result['Credentials']['SecretAccessKey'],
				'token'  => $result['Credentials']['SessionToken'],
				'expires' => $result['Credentials']['Expiration']->__toString()
			);
			file_put_contents($this->getStsTokenPath(), json_encode($credentials));
			return $credentials;
			// return $result['Credentials'];
		}
		catch (AwsException $e) {
			//echo "<pre>".$e->getMessage()."</pre>";
		}
	}

	private function getStsToken() {
		return $this->getFreshStsToken();
	}

	private function getAccessTokenExpirationTimestamp() {
		$tokenData = json_decode(file_get_contents($this->getAccessTokenPath()));
		return $tokenData->expires;
	}

	/**
	 * Determines if access token has expired yet.
	 */
	private function isTokenValid($tokenData=null) {
		if (!file_exists($this->getAccessTokenPath())) {
			return false;
		}
		if (!$tokenData) {
			$tokenData = json_decode(file_get_contents($this->getAccessTokenPath()));
		}
		return $tokenData->expires > time();
	}

	/**
	 * Gets headers for most API calls.
	 */
	private function getHeaders() {
		$dateTime = new DateTime('now', new DateTimeZone('UTC'));//->format('Ymd\THis\Z');
		$requestDateTime = $dateTime->format('Ymd\THis\Z');
		return array(
			'Host' => $this->getHost(),
			'x-amz-access-token' => $this->getAccessToken(), // Fetches token. Will generate new token if already expired.
			'x-amz-date' => $requestDateTime,
			'x-amz-security-token' => $this->stsCredentials['token'],
			'user-agent' => $this->getUserAgent()
		);
	}

	private function getHost() {
		if ($this->sandbox) {
			return 'sandbox.sellingpartnerapi-na.amazon.com';
		}
		else {
			return 'sellingpartnerapi-na.amazon.com';
		}
	}

	private function getUserAgent() {
		return "$this->apiName/$this->apiVersion (Language=PHP)";
	}

	private function initPaths() {
		$paths = new stdClass;
		$paths = array(
			'orders' => '/orders/v0/orders',
			'inventory' => '/fba/inventory/v1/summaries',
			'listCatalogItems' => '/catalog/v0/items'
		);

		$paths->getOrders = new stdClass;
		$paths->getOrders->path = '/orders/v0/orders';
		$paths->getOrders->method = GET;

		$this->paths = $paths;

	}
}
?>
