<?php

require '../RequestSigner.php';
class STSHelper {
	private static $endpoint = 'https://sts.amazonaws.com';
	private static $version = '2011-06-15';
	private static $region = 'us-east-1';
	private static $service = 'sts';
	private static $terminationString = 'aws4_request';
	private static $algorithm = 'AWS4-HMAC-SHA256';

	private $action;
	private $roleSessionName;
	private $headers;
	private $signer;
	private $credential;
	private $dateTime;

	public function __construct(array $headers, string $action, string $roleSessionName) {
		$this->action = $action;
		$this->roleSessionName = $roleSessionName;
		$this->headers = $headers;
		$this->credential = self::getCredential();
		$this->signer = new RequestSigner('GET', $this->createQueryString(), $headers, '', $this->credential);
		$this->dateTime = date_format(new DateTime('now', new DateTimeZone('UTC')), 'Ymd\THis\Z');
	}

	public function getStsToken() {
		$queryString = self::getQueryString($this->action, $this->roleSessionName);
	}

	public function createQueryString() {
		if ($action == "default" || $action == '') {
			$action = "AssumeRole";
		}
		if ($roleSessionName == "default" || $roleSessionName == '') {
			$roleSessionName = "testAR";
		}
		$endpoint = self::$endpoint;
		$version = self::$version;
		$roleArn = self::getRoleArn();
		return "$endpoint?Version=$version&Action=$action&RoleSessionName=$roleSessionName&RoleArn=$roleArn";
	}

	private function getAuthParams($headers, $action="default", $roleSessionName="testAR") {
		$signedRequestHeaders = $this->signer->signRequestHeaders($this->getAccessKey(), $this->getSecretKey());
		$signatureData = $this->signer->signRequest($this->getAccessKey(), $this->getSecretKey());
		$algoString = "X-Amz-Algorithm=" . self::$algorithm;
		$credentialString = "X-Amz-Credential=" . $this->credential->accessKey . "/" . $this->credential->date . "/" . $this->credential->region . "/" . $this->credential->service . "/" . $this->credential->terminationString;
		$dateString = "X-Amz-Date=" . $this->dateTime;
		$signatureString = "X-Amz-Signature=".$signatureData->signature;

	}

	private static function getRoleArn() {
		return trim(file_get_contents(HTML_FOLDER . "apis/amazon/keys/aws/sts/api_user_role_arn.txt"));
	}

	private static function getCredential() {
		$accessKey = self::getAccessKey();
		$date = date_format(new DateTime('now', new DateTimeZone('UTC')), 'Ymd');
		$region = self::$region;
		$service = self::$service;
		$terminationString = self::$terminationString;

		$credential = new stdClass;
		$credential->key = $accessKey;
		$credential->date = $date;
		$credential->region = $region;
		$credential->service = $service;
		$credential->terminationString = $terminationString;
		return $credential;

	}

	private static function getAccessKey() {
		return trim(file_get_contents(HTML_FOLDER . "apis/amazon/keys/aws/api_user/access_key_id.txt"));
	}

	private static function getSecretKey() {
		return trim(file_get_contents(HTML_FOLDER . "apis/amazon/keys/aws/api_user/secret_access_key.txt"));
	}
}

?>
