<?php

require_once(HTML_FOLDER . "apis/amazon/mws/config/mwsconfig.php");
require_once(HTML_FOLDER . 'apis/amazon/mws/src/MarketplaceWebServiceOrders/Client.php');
require_once(HTML_FOLDER . 'apis/amazon/mws/src/MarketplaceWebServiceOrders/Model/GetOrderRequest.php');
require_once(HTML_FOLDER . 'apis/amazon/mws/src/MarketplaceWebServiceOrders/Model/ListOrdersRequest.php');
require_once(HTML_FOLDER . 'apis/amazon/mws/src/MarketplaceWebServiceOrders/Model/ListOrdersByNextTokenRequest.php');
require_once(HTML_FOLDER . 'apis/amazon/mws/src/MarketplaceWebServiceOrders/Model/ListOrderItemsRequest.php');
// require_once(HTML_FOLDER . 'apis/amazon/mws/src/MarketplaceWebServiceOrders/Samples/ListOrdersSample.php');

class AmazonMWS extends Database {
	private static $serviceUrls = array(
		'orders' => "https://mws.amazonservices.com/Orders/2013-09-01",
		'finances' => "https://mws.amazonservices.com/Finances/2015-05-01"
	);

	private $amazonChannelId;
	private $service;

	private $numProcessed = 0;
	private $startTime;

	public function __construct() {
		$this->amazonChannelId = $this->getAmazonChannelId();
		$this->startTime = time();


		$serviceUrl = "https://mws.amazonservices.com/Orders/2013-09-01";
		$config = array (
			'ServiceURL' => $serviceUrl,
			'ProxyHost' => null,
			'ProxyPort' => -1,
			'ProxyUsername' => null,
			'ProxyPassword' => null,
			'MaxErrorRetry' => 3,
		);

		$service = new MarketplaceWebServiceOrders_Client(
				AWS_ACCESS_KEY_ID,
				AWS_SECRET_ACCESS_KEY,
				APPLICATION_NAME,
				APPLICATION_VERSION,
				$config);
		$this->service = $service;
	}

	public function getOrder($orderNumbers=null) {
		if (!$orderNumbers) {
			return '';
		}
		$service = self::getService('orders');
		$request = new MarketplaceWebServiceOrders_Model_GetOrderRequest();
		$request->setSellerId(MERCHANT_ID);
		if ($orderNumbers) {
			$request->setAmazonOrderId($orderNumbers);
		}
		$result = self::invokeGetOrder($service, $request);
		return $result;
	}

	public function getOpenOrders() {
		$service = self::getService('orders');
		$request = new MarketplaceWebServiceOrders_Model_ListOrdersRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setMarketplaceId(MARKETPLACE_ID);
		$request->setCreatedAfter(date_format(new DateTime('1 month ago', new DateTimeZone('UTC')), 'Y-m-d'));
		$orderStatus = array(
			'Pending',
			'Unshipped',
			'PartiallyShipped'
		);
		$request->setOrderStatus($orderStatus);
		$result = $this->listOrders($service, $request);
		return $result;
	}

	public function getFullOrderHistory($startMonth='01') {
		$this->resetAutoIncrement('ecomm_ship_log');
		$this->resetAutoIncrement('ecomm_amazon_listings');
		$month = $startMonth;
		$year = date_format(new DateTime('now', new DateTimeZone('UTC')), 'Y');
		$year = '2021';
		if ($nextMonth > 12) {
			$nextMonth = strval($nextMonth - 12);
			$nextYear = strval((int)$year + 1);
		}
		else {
			$nextMonth = strval($nextMonth);
			$nextYear = $year;
		}
		if (strlen($nextMonth) == 1) {
			$nextMonth = '0' . $nextMonth;
		}
		$currentDate = new DateTime('now', new DateTimeZone('UTC'));


		$serviceUrl = "https://mws.amazonservices.com/Orders/2013-09-01";
		$config = array (
			'ServiceURL' => $serviceUrl,
			'ProxyHost' => null,
			'ProxyPort' => -1,
			'ProxyUsername' => null,
			'ProxyPassword' => null,
			'MaxErrorRetry' => 3,
		);

		$service = new MarketplaceWebServiceOrders_Client(
				AWS_ACCESS_KEY_ID,
				AWS_SECRET_ACCESS_KEY,
				APPLICATION_NAME,
				APPLICATION_VERSION,
				$config);
		$request = new MarketplaceWebServiceOrders_Model_ListOrdersRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setMarketplaceId(MARKETPLACE_ID);
		$request->setCreatedAfter("$year-$month-01");
		// $request->setCreatedBefore("$nextYear-$nextMonth-01");
		// object or array of parameters
		$fullResults = new stdClass;
		$fullResults->Orders = array();
		$this->startTime = time();
		$firstResult = $this->listOrders($service, $request);

		$orders = $firstResult->ListOrdersResult->Orders->Order;
		$this->performOrderInsertions($orders, $fullResults);
		if ($firstResult->ListOrdersResult->NextToken) {
			echo "<h2>Next token found</h2>";
			$nextToken = $firstResult->ListOrdersResult->NextToken;
			$i = 1;
			while ($nextToken && $nextToken != '') {
				$nextRequest = new MarketplaceWebServiceOrders_Model_ListOrdersByNextTokenRequest();
				$nextRequest->setSellerId(MERCHANT_ID);
				$nextRequest->setNextToken($nextToken);
				$nextResult = $this->listOrdersByNextToken($service, $nextRequest);
				// echo "<h2>Next result</h2>";
				// echo "<pre>";
				// print_r($nextResult);
				// echo "</pre>";
				$orders = $nextResult->ListOrdersByNextTokenResult->Orders->Order;
				$this->performOrderInsertions($orders, $fullResults);
				$nextToken = $nextResult->ListOrdersByNextTokenResult->NextToken;
				$i++;
				// sleep(15);
			}
			// print_r($firstResult->ListOrdersResult);
			echo "<h2>Done! Ran $i iterations.</h2>";
		}
		else {
			echo "<h2>No next token found</h2>";
			// print_r($firstResult->ListOrdersResult);
		}
		echo "<pre>";
		print_r($fullResults);
		echo "</pre>";
		$this->resetAutoIncrement('ecomm_ship_log');
		$this->resetAutoIncrement('ecomm_amazon_listings');

	}

	public function getOrderHistory($month='') {
		$this->resetAutoIncrement('ecomm_ship_log');
		$this->resetAutoIncrement('ecomm_amazon_listings');
		if ($month == '') {
			$month = date_format(new DateTime('now', new DateTimeZone('UTC')), 'm');
		}
		$year = date_format(new DateTime('now', new DateTimeZone('UTC')), 'Y');
		$nextMonth = (int)$month + 1;
		if ($nextMonth > 12) {
			$nextMonth = strval($nextMonth - 12);
			$nextYear = strval((int)$year + 1);
		}
		else {
			$nextMonth = strval($nextMonth);
			$nextYear = $year;
		}
		if (strlen($nextMonth) == 1) {
			$nextMonth = '0' . $nextMonth;
		}
		$currentDate = new DateTime('now', new DateTimeZone('UTC'));


		$serviceUrl = "https://mws.amazonservices.com/Orders/2013-09-01";
		$config = array (
			'ServiceURL' => $serviceUrl,
			'ProxyHost' => null,
			'ProxyPort' => -1,
			'ProxyUsername' => null,
			'ProxyPassword' => null,
			'MaxErrorRetry' => 3,
		);

		$service = new MarketplaceWebServiceOrders_Client(
				AWS_ACCESS_KEY_ID,
				AWS_SECRET_ACCESS_KEY,
				APPLICATION_NAME,
				APPLICATION_VERSION,
				$config);
		$request = new MarketplaceWebServiceOrders_Model_ListOrdersRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setMarketplaceId(MARKETPLACE_ID);
		$request->setCreatedAfter("$year-$month-01");
		$request->setCreatedBefore("$nextYear-$nextMonth-01");
		// object or array of parameters
		$fullResults = new stdClass;
		$fullResults->Orders = array();
		$firstResult = $this->listOrders($service, $request);

		$orders = $firstResult->ListOrdersResult->Orders->Order;
		$this->performOrderInsertions($orders, $fullResults);
		if ($firstResult->ListOrdersResult->NextToken) {
			echo "<h2>Next token found</h2>";
			$nextToken = $firstResult->ListOrdersResult->NextToken;
			$i = 1;
			while ($nextToken && $nextToken != '') {
				$nextRequest = new MarketplaceWebServiceOrders_Model_ListOrdersByNextTokenRequest();
				$nextRequest->setSellerId(MERCHANT_ID);
				$nextRequest->setNextToken($nextToken);
				$nextResult = $this->listOrdersByNextToken($service, $nextRequest);
				// echo "<h2>Next result</h2>";
				// echo "<pre>";
				// print_r($nextResult);
				// echo "</pre>";
				$orders = $nextResult->ListOrdersByNextTokenResult->Orders->Order;
				$this->performOrderInsertions($orders, $fullResults);
				$nextToken = $nextResult->ListOrdersByNextTokenResult->NextToken;
				$i++;
				// sleep(15);
			}
			// print_r($firstResult->ListOrdersResult);
			echo "<h2>Done! Ran $i iterations.</h2>";
		}
		else {
			echo "<h2>No next token found</h2>";
			// print_r($firstResult->ListOrdersResult);
		}
		echo "<pre>";
		print_r($fullResults);
		echo "</pre>";
		$this->resetAutoIncrement('ecomm_ship_log');
		$this->resetAutoIncrement('ecomm_amazon_listings');
	}

	public function listFinancialEvents() {
		$service = self::getService('finances');
		$request = new MWSFinancesService_Model_ListFinancialEventsRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setPostedAfter('2020-10-26T00:00:00');
		$request->setPostedBefore('2020-11-26T00:00:00');
		$request->setMaxResultsPerPage(100);
		$result = $this->invokeListFinancialEvents($service, $request);
		return $result;
	}

	public function getRefundsSinceDate($date) {
		$channelId = $this->getAmazonChannelId();

		// Get the start date
		$startDate = DateTime::createFromFormat('Y-m-d', $date, new DateTimeZone('UTC'));

		// Get the service and request
		$service = self::getService('finances');
		$request = new MWSFinancesService_Model_ListFinancialEventsRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setPostedAfter($startDate->format(DATE_ATOM));
		$request->setMaxResultsPerPage(100);
		return $this->getRefunds($service, $request);
	}

	public function getMonthRefunds($year, $month, $refunds=array()) {
		// Get the start and end dates
		$startDate = DateTime::createFromFormat('Y-m-d', "$year-$month-01", new DateTimeZone('UTC'));
		if (intval($month) == 12) {
			$endYear = strval(intval($year) + 1);
			$endMonth = '01';
		}
		else {
			$endYear = $year;
			$endMonth = intval($month) + 1 < 10 ? str_pad(strval(intval($month)+1), 1, '0') : strval(intval($month)+1);
		}
		$endDate = DateTime::createFromFormat('Y-m-d', "$endYear-$endMonth-01", new DateTimeZone('UTC'));

		// Get the service and request
		$service = self::getService('finances');
		$request = new MWSFinancesService_Model_ListFinancialEventsRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setPostedAfter($startDate->format(DATE_ATOM));
		$request->setPostedBefore($endDate->format(DATE_ATOM));
		$request->setMaxResultsPerPage(100);
		return $this->getRefunds($service, $request);
	}



	public function getAllRefunds() {
		$channelId = $this->getAmazonChannelId();
		$months = array('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11');
		$refunds = array();
		echo "<pre>";
		foreach ($months as $month) {
			$refunds = $this->getMonthRefunds('2020', $month, $refunds);
		}
		print_r($refunds);
		foreach ($refunds as $refund) {
			$orderId = $refund->orderId;
			$ecommId = $refund->ecommId;
			$returnDate = $refund->returnDate;
			$returnAmount = $refund->returnAmount;
			$attempts = 0;
			while (!$ecommId && $attempts < 3) {
				$sql = "INSERT INTO `ecomm_ship_log`(`order_id`, `channel_id`, `subtotal`) VALUES ('$orderId','$channelId','$returnAmount');";
				echo "$sql\n";
				$this->db_query($sql, 'insert', true);
				$ecommId = $this->getEcommId($orderId);
				$attempts++;
			}
			$sql = "INSERT INTO `ecomm_return_log`(`ecomm_id`, `return_date`, `return_amount`) VALUES ('$ecommId', '$returnDate', '$returnAmount') ON DUPLICATE KEY UPDATE `return_date`='$returnDate', `return_amount`='$returnAmount';";
			echo "$sql\n";
			$this->db_query($sql, 'insert', true);
		}
		echo "</pre>";
	}

	private function getRefunds(MWSFinancesService_Interface $service, $request) {
		$result = $this->invokeListFinancialEvents($service, $request);
		$returnedRefunds = $result->ListFinancialEventsResult->FinancialEvents->RefundEventList->ShipmentEvent;

		// Ensure there are refunds in the result
		if ($returnedRefunds) {
			if (!is_array($returnedRefunds)) {
				$returnedRefunds = array($returnedRefunds);
			}
			// Parse the refunds
			foreach ($returnedRefunds as $refund) {
				$orderId = $refund->AmazonOrderId;
				$returnDate = new DateTime($refund->PostedDate, new DateTimeZone('UTC'));
				$returnDate = $returnDate->format("Y-m-d H:i:s");
				$returnAmount = 0.0;
				$chargeComponents = $refund->ShipmentItemAdjustmentList->ShipmentItem->ItemChargeAdjustmentList->ChargeComponent;
				if (!is_array($chargeComponents)) {
					$chargeComponents = array($chargeComponents);
				}

				// Parse the refund amounts
				foreach ($chargeComponents as $component) {
					$chargeType = $component->ChargeType;
					$chargeAmount = $component->ChargeAmount->CurrencyAmount;
					if ($chargeType != 'Tax' && $chargeType != "ShippingTax" && $chargeType != "ShippingCharge") {
						$returnAmount += (float)$chargeAmount;
					}
				}

				// Ensure the amount is nonzero
				if ($returnAmount) {
					$returnAmount = abs($returnAmount);

					// Build the object with the data and insert it into refunds array
					if ($refunds[$orderId]) {
						$refunds[$orderId]->returnAmount += $returnAmount;
						$refunds[$orderId]->returnDate = $returnDate;
					}
					else {
						$ecommId = $this->getEcommId($orderId);
						$refundObject = new stdClass;
						$refundObject->orderId = $orderId;
						$refundObject->ecommId = $ecommId;
						$refundObject->returnDate = $returnDate;
						$refundObject->returnAmount = $returnAmount;
						$refunds[$orderId] = $refundObject;
					}
				}
			}
		}

		// Extract the NextToken from the result
		$nextToken = $result->ListFinancialEventsResult->NextToken;


		while ($nextToken) {
			// Build request
			$request = new MWSFinancesService_Model_ListFinancialEventsByNextTokenRequest();
			$request->setSellerId(MERCHANT_ID);
			$request->setNextToken($nextToken);
			// Invoke request
			$result = $this->invokeListFinancialEventsByNextToken($service, $request);
			// print_r($result);

			// Extract refunds
			$returnedRefunds = $result->ListFinancialEventsByNextTokenResult->FinancialEvents->RefundEventList->ShipmentEvent;
			if (!$returnedRefunds) {
				$nextToken = $result->ListFinancialEventsByNextTokenResult->NextToken;
				continue;
			}
			if (!is_array($returnedRefunds)) {
				$returnedRefunds = array($returnedRefunds);
			}

			// Parse the refunds
			foreach ($returnedRefunds as $refund) {
				$orderId = $refund->AmazonOrderId;
				$returnDate = new DateTime($refund->PostedDate, new DateTimeZone('UTC'));
				$returnDate = $returnDate->format("Y-m-d H:i:s");
				$returnAmount = 0.0;
				$chargeComponents = $refund->ShipmentItemAdjustmentList->ShipmentItem->ItemChargeAdjustmentList->ChargeComponent;

				// Parse the refund amounts
				foreach ($chargeComponents as $component) {
					$chargeType = $component->ChargeType;
					$chargeAmount = $component->ChargeAmount->CurrencyAmount;
					if ($chargeType != 'Tax' && $chargeType != "ShippingTax" && $chargeType != "ShippingCharge") {
						$returnAmount += (float)$chargeAmount;
					}
				}
				if ($returnAmount) {
					$returnAmount = abs($returnAmount);

					// Build the object with the data and insert it into refunds array
					if ($refunds[$orderId]) {
						$refunds[$orderId]->returnAmount += $returnAmount;
						$refunds[$orderId]->returnDate = $returnDate;
					}
					else {
						$ecommId = $this->getEcommId($orderId);
						$refundObject = new stdClass;
						$refundObject->orderId = $orderId;
						$refundObject->ecommId = $ecommId;
						$refundObject->returnDate = $returnDate;
						$refundObject->returnAmount = $returnAmount;
						$refunds[$orderId] = $refundObject;
					}
				}
			}
			$nextToken = $result->ListFinancialEventsByNextTokenResult->NextToken;
		}
		return $refunds;

	}

	private function invokeListFinancialEvents(MWSFinancesService_Interface $service, $request) {
		try {
			$response = $service->ListFinancialEvents($request);
			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			$xml = $dom->saveXML();
			$orderData = new SimpleXMLElement($xml);
			$array = json_decode(json_encode($orderData, TRUE));
			return $array;

		}
		catch (MWSFinancesService_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
		}
	}

	private function invokeListFinancialEventsByNextToken(MWSFinancesService_Interface $service, $request) {
		try {
			$response = $service->ListFinancialEventsByNextToken($request);
			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			$xml = $dom->saveXML();
			$orderData = new SimpleXMLElement($xml);
			$array = json_decode(json_encode($orderData, TRUE));
			return $array;

	   } catch (MWSFinancesService_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
	   }
	}

	private function performOrderInsertions($orders, &$fullResults) {
		foreach ($orders as $order) {
			if ($order->OrderStatus == 'Shipped') {
				$startTime = time();
				$minTime = 2;
				$orderData = new stdClass;
				$orderData->AmazonOrderId = $order->AmazonOrderId;
				$orderData->PurchaseDate = $order->PurchaseDate;
				$orderData->ShipServiceLevel = $order->ShipServiceLevel;
				$orderData->OrderTotal = 0;
				$orderData->ShipDate = $order->EarliestShipDate;
				$orderItems = self::getOrderItems($orderData->AmazonOrderId);
				foreach ($orderItems as $orderItem) {
					$orderData->OrderTotal += (float)$orderItem->price;
				}

				$channelId = $this->amazonChannelId;


				$sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderData->AmazonOrderId', '$channelId', '$orderData->PurchaseDate', '$orderData->OrderTotal') ON DUPLICATE KEY UPDATE `subtotal`='$orderData->OrderTotal';";
				$this->db_query($sql, 'insert', true);

				$orderData->Query = $sql;

				$sql = "INSERT IGNORE INTO `ecomm_shipping_details`(`ecomm_id`, `ship_date`, `ship_method`) VALUES ((SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderData->AmazonOrderId'), '$orderData->ShipDate', '$orderData->ShipServiceLevel');";
				$this->db_query($sql, 'insert', true);

				foreach ($orderItems as $orderItem) {
					$title = mysql_real_escape_string($orderItem->title);
					$sql = "INSERT IGNORE INTO `ecomm_amazon_listings`(`sku`, `order_item_id`, `title`) VALUES ('$orderItem->sku', '$orderItem->itemId', '$title');";
					$this->db_query($sql, 'insert', true);
					$this->resetAutoIncrement('ecomm_amazon_listings');
					$sql = "INSERT IGNORE INTO `ecomm_amazon_listings_shipped`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `ecomm_amazon_listings` WHERE `order_item_id` = '$orderItem->itemId'), (SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderData->AmazonOrderId'),'$orderItem->quantity');";
					$this->db_query($sql, 'insert', true);
				}

				$orderData->OrderItems = $orderItems;

				array_push($fullResults->Orders, $orderData);
				$this->numProcessed++;

				if ($this->numProcessed > 0 && $this->numProcessed % 100 == 0) {
					$timeElapsed = time() - $this->startTime;
					echo "Processed $this->numProcessed orders so far in $timeElapsed seconds.\n";
				}

				self::sleep_until($startTime + $minTime, 1);
			}
		}
	}

	private static function invokeGetOrder(MarketplaceWebServiceOrders_Interface $service, $request) {
		try {
			$response = $service->GetOrder($request);
			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			$xml = $dom->saveXML();
			$orderData = new SimpleXMLElement($xml);
			$array = json_decode(json_encode($orderData, TRUE));
			return $array;

		} catch (MarketplaceWebServiceOrders_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
		}
	}

	private function listOrders(MarketplaceWebServiceOrders_Interface $service, $request) {
		try {
			$response = $service->ListOrders($request);
			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			// echo $dom->saveXML();
			$xml = $dom->saveXML();
			$orderData = new SimpleXMLElement($xml);
			$array = json_decode(json_encode($orderData, TRUE));
			return $array;

		} catch (MarketplaceWebServiceOrders_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Attempted function which failed: listOrders\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
		}
	}

	private function listOrdersByNextToken(MarketplaceWebServiceOrders_Interface $service, $request) {
		try {
			$response = $service->ListOrdersByNextToken($request);
			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			// echo $dom->saveXML();
			$xml = $dom->saveXML();
			$orderData = new SimpleXMLElement($xml);
			$array = json_decode(json_encode($orderData, TRUE));
			return $array;

		} catch (MarketplaceWebServiceOrders_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Attempted function which failed: listOrdersByNextToken\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
		}
	}

	public static function getOrderItems($orderId) {
		$service = self::getService('orders');
		$request = new MarketplaceWebServiceOrders_Model_ListOrderItemsRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setAmazonOrderId($orderId);
		// object or array of parameters
		$orderItemsResult = self::listOrderItems($service, $request);
		// echo "<pre>";
		// print_r($orderItemsResult);
		// echo "</pre>";
		// exit;
		$orderItemData = array();
		$orderItem = $orderItemsResult->ListOrderItemsResult->OrderItems->OrderItem;
		if (is_array($orderItem)) {
			$orderItems = $orderItemsResult->ListOrderItemsResult->OrderItems->OrderItem;
			foreach ($orderItems as $orderItem) {
				if ($orderItemData[$orderItem->ASIN]) {
					$orderItemData[$orderItem->ASIN]->quantity += $orderItem->QuantityOrdered;
				}
				else {
					$itemData = new stdClass;
					$itemData->itemId = $orderItem->ASIN;
					$itemData->sku = $orderItem->SellerSKU;
					$itemData->title = $orderItem->Title;
					$itemData->quantity = $orderItem->QuantityOrdered;
					$itemData->price = $orderItem->ItemPrice->Amount;
					$orderItemData[$itemData->OrderItemId] = $itemData;
				}
			}
		}
		else {
			$itemData = new stdClass;
			$itemData->itemId = $orderItem->ASIN;
			$itemData->sku = $orderItem->SellerSKU;
			$itemData->title = $orderItem->Title;
			$itemData->quantity = $orderItem->QuantityOrdered;
			$itemData->price = $orderItem->ItemPrice->Amount;
			$orderItemData[$itemData->OrderItemId] = $itemData;
		}
		return $orderItemData;
	}


	private static function listOrderItems(MarketplaceWebServiceOrders_Interface $service, $request) {
		try {
			$response = $service->ListOrderItems($request);

			// echo ("Service Response\n");
			// echo ("=============================================================================\n");

			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			// echo $dom->saveXML();
			$xml = $dom->saveXML();
			$orderData = new SimpleXMLElement($xml);
			$array = json_decode(json_encode($orderData, TRUE));
			return $array;
			// echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");

		} catch (MarketplaceWebServiceOrders_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Attempted function which failed: listOrderItems\n");
			echo("When attempting to call with Amazon order id:".$request->getAmazonOrderId()."\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
		}
	}

	private static function getCurrentMonth() {
		return date_format(new DateTime('now', new DateTimeZone('UTC')), 'm');
	}

	private static function getNextMonth($month='') {
		if ($month == '') {
			$month = self::getCurrentMonth();
		}
		$monthNum = (int)$month;
		$nextMonthNum = $monthNum + 1;
	}

	public function getAmazonChannelId() {
		$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='amazon' LIMIT 1";
		$result = $this->db_query($sql, 'select-single', true);
		return $result['id'];
	}

	private function getEcommId($orderId) {
		$sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId' LIMIT 1;";
		$result = $this->db_query($sql, 'select-single', true);
		if ($result) {
			return $result['id'];
		}
		else {
			return false;
		}
	}

	private static function getServiceUrl($api) {
		return self::$serviceUrls[strtolower($api)];
	}

	private static function getConfig($api) {
		$config = array (
			'ServiceURL' => self::getServiceUrl($api),
			'ProxyHost' => null,
			'ProxyPort' => -1,
			'ProxyUsername' => null,
			'ProxyPassword' => null,
			'MaxErrorRetry' => 3,
		);
		return $config;
	}

	private static function getService($api) {
		if ($api == 'orders') {
			$service = new MarketplaceWebServiceOrders_Client(
					AWS_ACCESS_KEY_ID,
					AWS_SECRET_ACCESS_KEY,
					APPLICATION_NAME,
					APPLICATION_VERSION,
					self::getConfig($api));
		}
		elseif ($api == 'finances') {
			$service = new MWSFinancesService_Client(
					AWS_ACCESS_KEY_ID,
					AWS_SECRET_ACCESS_KEY,
					APPLICATION_NAME,
					APPLICATION_VERSION,
					self::getConfig($api));
		}
		return $service;
	}
}

?>
