<?php

require_once 'API.class.php';
require_once '../../settings.php';
require_once '../../class_framework.php';
require_once '../../class_database.php';
require_once '../../class_admin.php';
require_once '../../class_customer.php';
require_once '../../class_order.php';
require_once '../../class_cart.php';
require_once '../../class_zoho.php';

global $ipad_colors;

$sourceplusArray = array(4,5,6);
$pigArray= array(7,8,9);

$adminObj = new Admin();
$custObj = new Customer();
$orderObj = new Order();
$cartObj = new Cart();
$zohoObj = new Zoho();

class MyAPI extends API
{
    protected $User;

    public function __construct($request) {
        parent::__construct($request);
        
        if (!array_key_exists('authid', $this->request)) {
            throw new Exception('No API Key provided');
        } else if ($this->request['authid'] != REFURB_CSTRING) {
            throw new Exception('Invalid API Key');
        } 
        
    }

    /**
     * Example of an Endpoint
     */
     protected function example($data) {
        if ($this->method == 'GET') {
            $this->api_log($data, '','example');
            return json_encode($data);
        } else {
            return "Only accepts GET requests";
        }
     }
     
     protected function test($data) {
        if ($this->method == 'POST') {
            return json_encode($data);
        } else {
            return "Only accepts POST requests";
        }
     }
     
     protected function ipadaudit($data) {
        if ($this->method == 'POST') {
            $return = json_encode($this->_ipadaudit($data));
            $this->api_log($data, $return,'ipadaudit');
            return $return;
        } else {
            return "Only accepts POST requests";
        }
     }
     
     protected function reprintlabel($data) {
        if ($this->method == 'POST') {
            $return = json_encode($this->_reprintlabel($data));
            $this->api_log($data, $return,'reprintlabel');
            return $return;
        } else {
            return "Only accepts POST requests";
        }
     }
     
     protected function deleteorder($data) {
        if ($this->method == 'POST') {
            $return = json_encode($this->_deleteorder($data));
            $this->api_log($data, $return,'deleteorder');
            return $return;
        } else {
            return "Only accepts POST requests";
        }
     }
     
     protected function zohoinvoice($data) {
        if ($this->method == 'GET') {
            
        /* Bilal Modifications */        
//            $return = json_encode($this->_zohoinvoice($data));
            $return = $this->_zohoinvoice($data);
            $this->api_log($data, $return,'zohoinvoice');
            return $return;
        } else {
            return "Only accepts GET requests";
        }
     }
     
     private function api_log($data,$return,$function_called){
         
         global $adminObj;
         
         $adminObj->db_insert('api_log', array('api_call' => serialize($data),'api_response' => $return,'function_called' => $function_called));
         
     }
     
     private function _ipadaudit($data){
         
        global $adminObj, $orderObj, $ipad_colors;
         
        $sourceplusArray = array(4,5,6);
        $pigArray= array(7,8,9);
        
        $adminObj->db_connect();

        if (strlen($data['serialNumber']) < 13){
            $configCode = substr($data['serialNumber'],8);
        }else{
            $configCode = substr($data['serialNumber'],9);
        }

        $sql = 'select mon.order_number
                from machine_order_number mon
                left join product_model pm on pm.order_number_id = mon.order_number_id
                where pm.configCode = "'.$configCode.'"';

        $machine_info = $adminObj->db_query($sql, 'select-single');

        $data['order_number'] = $machine_info['order_number'];

        $order = $adminObj->db_select_single('ds_orders', 'serialNumber, oNum', array('serialNumber' => $data['serialNumber']),' AND oNum LIKE "SP%"');

        $adminObj->db_delete('ipad_configurator_failed', 'ZSERIALNUMBER', $data['serialNumber']);

        if ($order['serialNumber'] == $data['serialNumber']){
            $lock_changed = false;
            if ($order['activation_lock'] == 1 && $data['locked'] != 'A'){
                $adminObj->db_update('ds_orders', 'oID', $order['oID'], array('activation_lock' => 0));
                $orderObj->insert_log($order['oID'], '', 'Device unlocked');
                $lock_changed = true;
            }
            if ($order['mdm_lock'] == 1 && $data['locked'] != 'M'){
                $adminObj->db_update('ds_orders', 'oID', $order['oID'], array('mdm_lock' => 0));
                $orderObj->insert_log($order['oID'], '', 'Device unlocked');
                $lock_changed = true;
            }
            if ($lock_changed){
                $data['oNum'] = $order['oNum'];
                $data['locked'] = '';
                if (in_array((int)$data['machine_id'], $sourceplusArray)){
                    $adminObj->print_ipad_label($data, ZEBRA_REFURB2_PRINTER);
                }elseif (in_array((int)$data['machine_id'], $pigArray)){
                    $adminObj->print_ipad_label($data, ZEBRA_PIG_PRINTER);
                }else{
                    $adminObj->print_ipad_label($data, ZEBRA_BEAST_PRINTER);
                }      
            }
            return 'Existing order no: '.$order['oNum'];
        }

        $imaging_control = $adminObj->db_select_single('imaging_control', 'po_number', array('machine_id' => $data['machine_id']));

        //$data['poNumber'] = $_POST['ponumber'];
        $data['poNumber'] = $imaging_control['po_number'];

        $hdsize = (float)$_POST['diskcapacity']/(1024*1024*1024);

        if ($hdsize < 16){
            $disk = '16GB';
        }elseif ($hdsize > 16 && $hdsize < 32) {
            $disk = '32GB';
        }elseif ($hdsize > 32 && $hdsize < 64) {
            $disk = '64GB';
        }else{
            $disk = '128GB';
        }

        $data['capacity'] = $disk;
        $data['is_ipad'] = 'true';
        
        if ($data['locked'] == 'A'){
            $data['activation_lock'] = '1';
            $data['audit_activation_lock'] = '1';
        }

        if ($data['locked'] == 'M'){
            $data['mdm_lock'] = '1';
            $data['audit_mdm_lock'] = '1';
        }
        
        if ($data['locked'] == 'false'){
            $data['locked'] = '';
        }
        
        if ($data['locked'] == 'true'){
            $data['locked'] = 'A';
        }

        if (array_key_exists($data['color'], $ipad_colors)){
            $data['color'] = $ipad_colors[$data['color']];
        }
        
        $oNum = $adminObj->parse_audit_response($data,false,true);
        
        $log = 'Imaged with OS '.$data['os_version'].', machine '.$data['machine_id'].', port '.$data['port'];

        if ($data['locked'] == 'A'){
            $log .= ', Activation Lock';
        }

        if ($data['locked'] == 'M'){
            $log .= ', MDM Lock';
        }

        
        $orderObj->insert_log($oNum, '', $log);

        $data['oNum'] = $oNum;

        if (in_array((int)$data['machine_id'], $sourceplusArray)){
            $adminObj->print_ipad_label($data, ZEBRA_REFURB2_PRINTER);
        }elseif (in_array((int)$data['machine_id'], $pigArray)){
            $adminObj->print_ipad_label($data, ZEBRA_PIG_PRINTER);
        }else{
            $adminObj->print_ipad_label($data, ZEBRA_BEAST_PRINTER);
        }
        
        return $oNum;
        
     }
     
     private function _reprintlabel($data){
         
        global $adminObj;
         
        $sourceplusArray = array(4,5,6);
        $pigArray = array(7,8,9);

        $adminObj->db_connect();

        $hdsize = (float)$_POST['diskcapacity']/(1024*1024*1024);

        if ($hdsize < 16){
            $disk = '16GB';
        }elseif ($hdsize > 16 && $hdsize < 32) {
            $disk = '32GB';
        }elseif ($hdsize > 32 && $hdsize < 64) {
            $disk = '64GB';
        }else{
            $disk = '128GB';
        }
        
        if ($data['locked'] == 'false'){
            $data['locked'] = '';
        }
        
        if ($data['locked'] == 'true'){
            $data['locked'] = 'A';
        }

        $data['capacity'] = $disk;

        $order = $adminObj->db_select_single('ds_orders', 'serialNumber, oNum', array('serialNumber' => $data['serialNumber']));

        $data['oNum'] = $order['oNum'];

        if ($order['serialNumber'] != ''){
            if (in_array((int)$data['machine_id'], $sourceplusArray)){
                $adminObj->print_ipad_label($data, ZEBRA_REFURB2_PRINTER);
            }elseif (in_array((int)$data['machine_id'], $pigArray)){
                $adminObj->print_ipad_label($data, ZEBRA_PIG_PRINTER);
            }else{
                $adminObj->print_ipad_label($data, ZEBRA_BEAST_PRINTER);
            }
        }
        
        return $data['oNum'];
        
     }
     
     private function _deleteorder($data){
         
        global $adminObj;
         
        $sql = 'SELECT oNum FROM ds_orders WHERE serialNumber = "'.$data['serialNumber'].'" AND oNum LIKE "SP%"';
        
        $order = $adminObj->db_query($sql, 'select-single');
         
        $oNum = $order['oNum'];
        
        $adminObj->db_delete('ds_orders', 'oNum', $oNum);
        
        return $oNum;
         
     }
     
     private function _zohoinvoice($data){
         
        global $zohoObj, $zoho_auth_tokens;
                  
        /* Bilal: Old code block comment out 
        
        $parameters = array(
            'scope'     =>  'crmapi'
            ,'selectColumns'    =>  'All'//columns to select
            ,'fromIndex'        =>  1//start record
            ,'toIndex'          =>  200//end record
            ,'criteria'  =>  '(MTS Quote Number:'.$data['MTSQuoteNo'].')'//filter
        );
        
        //this is to allow the record to get written to the CRM system.
        sleep(90);

        foreach ($zoho_auth_tokens as $auth_token) {
            $xml = $zohoObj->searchRecords($auth_token['authtoken'], $parameters, 'Invoices');
            $result = $xml;
            $count = count($result->result->Invoices->row);
                        
            if ($count > 0){
                $result = (array)$xml;
                return $result;
            }           
        }
         * 
         */
            
            /* Bilal Modifications */        
            $response = $zohoObj->searchRecords_api($data['MTSQuoteNo']);
            return $response;
         return '';
     }
 }
 
 // Requests from the same server don't have a HTTP_ORIGIN header
if (!array_key_exists('HTTP_ORIGIN', $_SERVER)) {
    $_SERVER['HTTP_ORIGIN'] = $_SERVER['SERVER_NAME'];
}

try {
    $API = new MyAPI($_REQUEST['request'], $_SERVER['HTTP_ORIGIN']);
    echo $API->processAPI();
} catch (Exception $e) {
    echo json_encode(Array('error' => $e->getMessage()));
}

