<?php

define('AREA', 'ADMIN');


//die( '$_RESPONSE<pre>'.print_r($_RESPONSE,true).'</pre>' );
require('settings.php');
require('class_framework.php');		$frmwkObj = new Framework;	# FRAMEWORK

require_once __DIR__ . '/vendor/autoload.php';
if (MODE == 'PROD' && (!$_SERVER['HTTPS'] || $_SERVER['HTTPS'] != 'on')) {
	$frmwkObj->goToURL('https://' . $_SERVER['SERVER_NAME'] . '/' . CONTROLLER . '?' . $_SERVER['QUERY_STRING']);
} else if (MODE == 'DEV' && ($_SERVER['HTTPS'] || $_SERVER['HTTPS'] == 'on')) {
    $frmwkObj->goToURL('http://' . $_SERVER['SERVER_NAME'] . '/' . CONTROLLER . '?' . $_SERVER['QUERY_STRING']);
}


require('class_squaretrade.php');	$sqrtObj = new Squaretrade;	# EXTENDS FRAMEWORK
require('class_database.php');		$dbObj = new Database;		# EXTENDS FRAMEWORK
require('class_payment.php');		$pmtObj = new Payment;		# EXTENDS DATABASE
require('class_admin.php');			$adminObj = new Admin;		# EXTENDS DATABASE
require('class_order.php');			$orderObj = new Order;		# EXTENDS DATABASE
require('class_search.php');		$searchObj = new Search;	# EXTENDS DATABASE
require('class_customer.php');		$custObj = new Customer;	# EXTENDS DATABASE
require('class_cart.php');			$cartObj = new Cart;		# EXTENDS DATABASE
require('class_ups.php');			$upsObj = new Ups;			# EXTENDS DATABASE
require('class_socialnet.php');		$socialObj = new SocialNet;
//require('class_gsx.php');			$gsxObj = new GSX;
require('class_google_contacts.php');           $googleObj = new GoogleContacts;
require('MCAPI.class.php');
require('class_mailchimp.php');         $mailchimpObj = new Mailchimp(MAILCHIMP_API_KEY);
require('class_timesheet.php');         $timesheetObj = new Timesheet;
require('class_zoho.php');              $zohoObj = new Zoho;
require('class_ebay.php');              $ebayObj = new eBay;
//require('class_zohoinvoice.php');       $zohoinvoiceObj = new zohoinvoice($zohoinvoice_tokens['token'],$zohoinvoice_tokens['org_id']);
require('class_fpdf.php');              #Base class, extended by class_pdf.php, which is the one we call.
require('class_pdf.php');               //$pdfObj = new pdf();
require('class_ecom.php');			$ecomObj = new ECom;
require('apis/shopify/class_shopify.php'); $shopifyObj = new Shopify;
require('apis/backmarket/class_backmarket.php'); $backmarketObj = new BackmarketAPI;
require('apis/ebay/class_ebay_api.php'); $ebayApiObj = new EbayAPI;
require('apis/newegg/class_newegg_api.php'); $neweggApiObj = new NeweggAPI;
require('apis/amazon/AmazonMWS.php');
require('classes/class_inventory.php');	$invObj = new Inventory;
require('classes/class_open_orders.php');	$openOrdersObj = new OpenOrders;
require('classes/class_ship_log.php');	$shipLogObj = new ShipLog;
require('classes/class_machine_database.php'); $machineDbObj = new MachineDatabase;
require('classes/class_imaging.php'); $imagingObj = new Imaging;
require('classes/class_executive.php'); $executiveObj = new Executive;
require('classes/class_worldship.php'); $worldshipObj = new Worldship;
require_once(HTML_FOLDER . "classes/Generic/loadGeneric.php");
require_once(HTML_FOLDER . "classes/OpenOrders/loadModule.php");
require_once(HTML_FOLDER . "classes/Encryption/loadModule.php");
require_once(HTML_FOLDER . "classes/Authentication/loadModule.php");
require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
require_once(HTML_FOLDER . "classes/Csv/loadModule.php");
require_once(HTML_FOLDER . "classes/SalesRegions/loadModule.php");
require('config/errorconfig.php');

if ($_GET['m'] == 'logout'){
	echo $_SERVER['QUERY_STRING'];
    $adminObj->admin_logout();
	$_SERVER['QUERY_STRING'] = '';
	$frmwkObj->goToUrl(CONTROLLER);
    exit;
}

if (!$adminObj->check_admin_login()) {
	$adminObj->admin_login($_POST, CONTROLLER . '?' . $_SERVER['QUERY_STRING']);
}

$action = isset($_GET['m']) ? $_GET['m'] : $_POST['action'];
$query = isset($_GET['q']) ? $_GET['q'] : $_POST['query'];
$search = isset($_GET['s']) ? $_GET['s'] : $_POST['search'];
$history = isset($_GET['history']) ? $_GET['history'] : false;
$dd_data = array('STATII' => $frmwkObj->arrayToHtmlSelectOptions(array_keys($order_statii)));

if ($action == 'logout'){
    $adminObj->admin_logout();
    exit;
}

// Authentication Start
if ($action == 'auth_validate') {
	AuthenticationController::renderValidationPage();

	exit;
}

if ($action == 'auth_verify') {
	$username = $_SESSION['aUser'];
	$code = $_GET['code'];
	if ($username && $code) {
		$result = AuthenticationController::validateKey($username, $code);
		echo json_encode($result);
		if ($result) {
			$_SESSION['2fa'] = time();
		}
		else {
			unset($_SESSION['2fa']);
		}
	}
	exit;
}

if ($action == 'auth_secretKeyTest') {
	AuthenticationController::generateSecretKeyTest();
	exit;
}

if ($action == 'auth_verifyTest') {
	$username = $_SESSION['aUser'];
	$code = $_GET['code'];
	if ($username && $code) {
		AuthenticationController::validateKey($username, $code);
	}
	exit;
}

if ($action == 'auth_renderQrCode') {
	AuthenticationController::renderQrCodePage();

	exit;
}

if (MODE == 'PROD') {
	$actionRequiresAuth = AuthenticationController::checkIfActionRequiresAuth($action);
	$currentUserHasAccess = AuthenticationController::checkIfCurrentUserHasAccess($action);
	$authCurrent = AuthenticationController::checkIfAuthCurrent();
}
else {
	$actionRequiresAuth = true;
	$currentUserHasAccess = true;
	$authCurrent = true;
}

if (!$authCurrent && $actionRequiresAuth) {
	header('Location: '. CONTROLLER . '?m=auth_validate&redirect=' . $action);
}

// Authentication End

if ($action == 'device_repair'){
    $adminObj->device_repair();
    exit;
}

if ($action == 'purchase_orders'){
    $adminObj->purchase_orders();
    exit;
}

if ($action == 'purchase_orders_v2'){
    require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	PurchaseOrdersController::dashboard();
	exit;
}
if ($action == 'purchase_orders_v2_get_inbound'){
    require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	$records = PurchaseOrdersController::getInboundPurchaseOrderRecords($_GET['searchText']);
	ob_end_clean();
	if(is_null($records)) {
		echo json_encode(array());
		exit;
	}
	echo json_encode($records);
	exit;
}
if ($action == 'purchase_orders_v2_checkin'){
    require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	PurchaseOrdersController::checkIn($_GET['po']);
	exit;
}
if ($action == 'purchase_orders_v2_checkin_fetch'){
    require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	$records = PurchaseOrdersController::checkInFetch($_GET['po']);
	echo json_encode($records);
	exit;
}
if ($action == 'purchase_orders_v2_receiving'){
    require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	
	$data = json_decode(str_replace('\\', '', file_get_contents('php://input')));
	PurchaseOrdersController::receving($_GET['po'], $data);
	exit;
}
if ($action == 'purchase_orders_v2_received'){
    require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	
	$data = json_decode(str_replace('\\', '', file_get_contents('php://input')));
	PurchaseOrdersController::received($_GET['po'], $data);
	exit;
}

if ($action == 'bb_delete_image'){
    $adminObj->bb_delete_image();
    exit;
}

if ($action == 'bb_receiving'){
    $adminObj->bb_receiving();
    exit;
}

if ($action == 'bb_status'){
    $adminObj->bb_status();
    exit;
}

if ($action == 'bb_report'){
    if ($_POST['submit_action'] == 'Report'){
        $adminObj->bb_report();
        exit;
    }
    if ($_POST['submit_action'] == 'Inventory'){
        $adminObj->bb_inventory();
        exit;
    }
}

if ($action == 'bb_report_submit'){
    if ($_POST['submit_action'] == 'CSV Export'){
        $searchObj->export_bb_report();
        exit;
    }
}

if ($action == 'bb_inventory_submit'){
    if ($_POST['submit_action'] == 'CSV Export'){
        $searchObj->export_bb_inventory();
        exit;
    }
}

if ($action == 'bb_detail_submit'){
    if ($_POST['submit_action'] == 'Export Audit Detail Report'){
        $searchObj->export_bb_detail($_POST['poNumber']);
        exit;
    }elseif ($_POST['submit_action'] == 'MDM/Activation Export'){
        if($searchObj->export_bb_locks($_POST['poNumber'])){
            exit;
        }else{
           $order_id = $_POST['order_id'];
            $adminObj->bb_detail($order_id);
            exit;
        }
    }elseif ($_POST['submit_action'] == 'Export Customer Audit Report'){
        $adminObj->bb_customer_audit_report();
        exit;
    }elseif ($_POST['submit_action'] == 'Edit Prices'){
        $adminObj->purchase_order_edit($_POST['order_id']);
        exit;
    }elseif ($_POST['submit_action'] == 'Add'){
        $adminObj->purchase_order_edit($_POST['order_id']);
        exit;
    }else{
        $order_id = $_POST['order_id'];
        $adminObj->bb_detail($order_id);
        exit;
    }
}

if ($action == 'bb_detail'){
    $order_id = $_GET['order_id'];
    $adminObj->bb_detail($order_id);
    // $buybackObj->bb_detail($order_id);
    exit;
}

if ($action == 'bb_print_rack_tag'){
    $adminObj->bb_print_rack_tag();
    exit;
}

if ($action == 'purchase_order_edit'){
    $adminObj->purchase_order_edit($_POST['order_id']);
    exit;
}

if ($action == 'imaging_control'){
    $adminObj->imaging_control();
    exit;
}

if ($action == 'keyboard_test'){
    $adminObj->keyboard_test();
    exit;
}

if ($action == 'serial_number_lookup'){
    $adminObj->serial_number_lookup($_POST);
    exit;
}

if ($action == 'ebay_shipping'){
    $adminObj->ebay_shipping();
    exit;
}

if ($action == 'file_exports'){
    // $adminObj->file_exports();
	header('Location: '. CONTROLLER . '?m=file_export');
    exit;
}

if ($action == 'orderexports'){
	require_once('class_cron.php');
	$cronObj = new Cron;
    $argv[4] = $_GET['date'];
    $argv[3] = $_GET['type'];
    $argv[5] = $_GET['dest'];
    //$cronObj->order_exports($argv);
    $cronObj->updateAmazonOrders(true);
    exit;
}

if ($action == 'get_grades'){
    $adminObj->get_grades($_POST['serialNumber'], $_POST['identifier']);
    exit;
}

if ($action == 'audit_grade_update'){
    $adminObj->audit_grade_update($_POST);
    exit;
}

if ($action == 'submit_audit'){
    $adminObj->parse_audit_response($_POST);
    exit;
}

if ($_SESSION['aAuditOnly'] == 'Y'){
    echo $frmwkObj->parse(TEMPLATE, array('BODY' => $adminObj->parse_audit_form($data), "TITLE" => "Audit"));
    exit;
}

if ($action == 'mass_order_update'){
    $adminObj->mass_order_update();
    exit;
}

if ($action == 'reprint_refurb_label'){
    $adminObj->reprint_refurb_label($_GET['oNum']);
}

if ($action == 'create_timesheet'){
    $timesheetObj->create_timesheet($_GET['aid'], $_GET['period_id']);
    exit;
}

if ($action == 'phpinfo'){
    echo phpinfo();
    exit;
}
if ($action == 'view_timesheets'){
    $adminObj->view_timesheets();
    exit;
}

if ($action == 'save_timesheet'){
    $adminObj->save_timesheet($_POST);
    exit;
}

if ($action == 'timesheet'){
    $adminObj->timesheet();
    exit;
}

if ($action == 'save_pay_period'){
    $adminObj->pay_period_save($_POST);
    exit;
}

if ($action == 'pay_period_edit'){
    $adminObj->pay_period_edit($_GET['period_id']);
    exit;
}

if ($action == 'pay_periods'){
    $adminObj->pay_periods();
    exit;
}

if ($action == 'edit_item'){
    $adminObj->edit_item($_POST);
    exit;
}

if ($action == 'view_item'){
    $adminObj->view_item($_GET['pID'],$_GET['machine_id']);
    exit;
}

if ($action == 'machine_image'){
    $adminObj->machine_image();
    exit;
}

// Machine Database start

if ($action == 'order_number_edit'){
    $machineDbObj->order_number_edit($_GET['order_number_id']);
    exit;
}

if ($action == 'find_machine'){
    $machineDbObj->find_machine($_POST['serialNumber']);
    exit;
}


if ($action == 'save_order_number'){
    $machineDbObj->order_number_edit($_GET['order_number_id']);
    exit;
}

if ($action == 'submit_order_number') {
	$machineDbObj->submitOrder($_POST);
	exit;
}

if ($action == 'machine_edit'){
    $machineDbObj->machine_edit($_GET['machine_id']);
    exit;
}

if ($action == 'machine_detail'){
    $machineDbObj->machine_detail($_GET['machine_id']);
    exit;
}

if ($action == 'machine_database'){
    $machineDbObj->machine_database();
    exit;
}

if ($action == 'get_shipping_boxes') {
	echo json_encode($machineDbObj->getShippingBoxData($_POST['order_number_id']));
	exit;
}

if ($action == 'delete_sku_ship_box') {
	echo json_encode($machineDbObj->deleteSkuShipBox($_POST['order_number_id'], $_POST['ship_box_id']));
	exit;
}

if ($action == 'machinedb_validate_unique_configcode') {
	$configCodes = $_GET['configCodes'];
	$orderNumberId = $_GET['orderNumberId'];
	echo json_encode($machineDbObj->validateConfigCodesUnique($orderNumberId, $configCodes));
	exit;
}

if ($action == 'machinedb_validate_unique_sku') {
	$sku = $_GET['sku'];
	$orderNumberId = $_GET['orderNumberId'];
	echo json_encode($machineDbObj->validateSkuUnique($orderNumberId, $sku));
	exit;
}

if ($action == 'machinedb_delete_sku') {
	$orderNumberId = $_GET['orderNumberId'];
	$machineDbObj->deleteSku($orderNumberId);
	exit;
}

// Machine Database end

if ($action == 'edit_users'){
    $adminObj->edit_users();
    exit;
}

if ($action == 'add_user'){
    $adminObj->add_user($_POST);
    exit;
}

if ($action == 'save_user'){
    $adminObj->save_user($_POST);
    exit;
}

if ($action == 'user_detail'){
    $adminObj->user_detail($_GET['aString']);
    exit;
}

if ($action == 'edit_po_numbers'){
    $adminObj->edit_po_numbers();
    exit;
}

if ($action == 'po_number_delete'){
    $adminObj->delete_po_number($_GET['po_number_id']);
    exit;
}

if ($action == 'add_po_number'){
    $adminObj->add_po_number($_POST['po_number']);
    exit;
}

if ($action == 'open_repairs'){
    $adminObj->repair_lookup();
    exit;
}

if ($action == 'serial_lookup_export'){
    $adminObj->serial_lookup_export($_POST);
    exit;
}

if ($action == 'mass_serial_lookup'){
    $adminObj->mass_serial_lookup($_POST);
    exit;
}

if ($action == 'worldship_detail'){
    $adminObj->worldship_detail($_GET['tracking_no']);
    exit;
}

if ($action == 'worldship_log'){
    $adminObj->worldship_log($_POST);
    exit;
}

if ($action == 'ups_worldship'){
    $adminObj->ups_worldship($_POST);
    exit;
}

if ($action == 'ups_get_quote'){
    $adminObj->ups_get_quote($_POST);
    exit;
}

if ($action == 'worldship'){
    $adminObj->worldship_new();
    exit;
}

if ($action == 'worldship_new'){
	$adminObj->worldship_new();
	exit;
}

if ($action == 'worldship_search') {
	$worldshipObj->getAddresses($_POST['searchstring']);
	exit;
}

if ($action == 'worldship_get_variants') {
	$worldshipObj->getAddressVariants($_POST['searchstring']);
	exit;
}

if ($action == 'ups_reprint_label'){
    $adminObj->ups_reprint_label($_POST['tracking_no']);
    exit;
}

if ($action == 'get_machine_info'){
    $adminObj->get_machine_info($_POST['serialNumber']);
    exit;
}

if ($action == 'get_order_number'){
    $adminObj->get_order_number($_POST['serialNumber'],$_POST['target']);
    exit;
}

if ($action == 'edit_items'){
    $adminObj->edit_items();
    exit;
}

if ($action == 'update_status'){
    $adminObj->update_multiple_status($_POST['chkSelect'], $_POST['cboStatus']);
}

if ($action == 'process_metrics'){
    $adminObj->process_metrics();
    exit;
}

if ($action == 'diag_form'){
    $oNum = isset($_GET['oNum']) ? $_GET['oNum'] : $_POST['oNum'];
    $adminObj->diag_form($oNum);
}

if ($action == 'parts_export'){
    $adminObj->parts_export();
    exit;
}

if ($action == 'parts_lookup'){
    $adminObj->parts_lookup();
    exit;
}

if ($action == 'print_labels'){
    $adminObj->printLabels();
    exit;
}

if ($action == 'disable_emails'){
    if($_GET['type'] == 'order'){
        echo $adminObj->disableEmails($_GET['id'],'order');
    }else{
        echo $adminObj->disableEmails($_GET['id'],'customer');
    }
    exit;
}

if ($action == 'multiple_orders'){
    echo $adminObj->multiple_orders($_GET['id']);
    exit;
}

// general debug start

if ($action == 'debug_printSession' && MODE == 'DEV') {
	echo "<pre>";
	echo time() . "\n";
	print_r($_SESSION);
	echo "</pre>";
	exit;
}

if ($action == "phpinfo") {
	phpinfo();
	exit;
}

if ($action == "zohoGetOpenInvoices") {
	$zohoObj->getOpenInvoices();
	exit;
}

if ($action == "zohoGetInvoiceDetails") {
	$zohoId = $_GET['zohoIdd'];
	if (!$zohoId) {
		$zohoId = '835703000098242050';
	}
	$data = $zohoObj->getInvoiceAccountAndContactDetails($zohoId);
	echo "<pre>";
	print_r($data);
	exit;
}

// general debug end

// generic ajax start

if ($action == "ajax_getRegions") {
	$regions = Region::getAllRegions();
	$regionJson = array();
	foreach ($regions as $region) {
		array_push($regionJson, $region->jsonify());
	}
	echo json_encode($regionJson);
	exit;
}

if ($action == "ajax_getStates") {
	$states = State::getAllStates();
	$stateJson = array();
	foreach ($states as $state) {
		array_push($stateJson, $state->jsonify());
	}
	echo json_encode($stateJson);
	exit;
}

if ($action == "ajax_getSalespersons") {
	$salespersons = Salesperson::getAllSalespersons();
	$salespersonJson = array();
	foreach ($salespersons as $salesperson) {
		array_push($salespersonJson, $salesperson->jsonify());
	}
	echo json_encode($salespersonJson);
	exit;
}

// generic ajax end

// Dropbox test start

if ($action == "dropbox_getAppDetails") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::getAppDetails();
	exit;
}

if ($action == "dropbox_authRedirect") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::getAppDetails();
	exit;
}

if ($action == "dropbox_getAuthUrl") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::showAuthUrl();
	exit;
}

if ($action == "dropbox_submitAuthCode") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	$authCode = trim($_POST['authorization_code']);
	DropboxAPIController::submitAuthCode($authCode);
	// echo "$authCode";
	exit;
}

if ($action == "dropbox_getRefreshTokenTest") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::getRefreshTokenTest();
	exit;
}

if ($action == "dropbox_refreshAccessTokenTest") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::refreshAccessTokenTest();
	exit;
}

if ($action == "dropbox_testFileUpload") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::testFileUpload();
	exit;
}

if ($action == "dropbox_testLargeFileUpload") {
	require_once(HTML_FOLDER . "apis/dropbox/loadModule.php");
	DropboxAPIController::testLargeFileUpload();
	exit;
}

// Dropbox test end

// Email List Start

if ($action == "emailList") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::renderPage();
	exit;
}

if ($action == "emailList_import") {
	echo "<h2>Deprecated path</h2>";
	// require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	// EmailListController::emailListImport();
	exit;
}

if ($action == "emailList_getSetupData") {
	$regions = Region::getAllRegions();
	$regionJson = array();
	foreach ($regions as $region) {
		array_push($regionJson, $region->jsonify());
	}

	$accountTypes = Account::getAccountTypes();

	$setupData = new stdClass;
	$setupData->accountTypes = $accountTypes;
	$setupData->regions = $regionJson;
	echo json_encode($setupData);
	exit;
}

if ($action == "emailList_get") {
	$searchParams = $_GET;
	// print_r($searchParams);
	// print_r($searchParams);
	// echo json_encode($searchParams, JSON_PRETTY_PRINT);

	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	echo json_encode(EmailListController::fetchList($searchParams));
	exit;
}

if ($action == "emailList_export") {
	$searchParams = $_GET;

	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	echo EmailListController::exportList($searchParams);
	exit;
}

if ($action == "emailList_testImport") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::importFromCsv($_GET['fileName']);
	exit;
}

if ($action == "emailList_zohoAccountImport") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::accountCsvImport();
	exit;
}

if ($action == "emailList_zohoContactsImport") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::contactsCsvImport();
	exit;
}

if ($action == "emailList_zohoLeadsImport") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::leadsCsvImport();
	exit;
}

if ($action == "emailList_constantContactImport") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::constantContactCsvImport();
	exit;
}

if ($action == "emailList_consolidateContacts") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::consolidateContacts();
	exit;
}

if ($action == 'emailList_getByEmailTest') {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	$email = $_GET['email'] ? $_GET['email'] : 'rwostratzky@lhs210.net';
	EmailListController::getDataByEmailAddress($email);
	exit;
}

if ($action == 'emailList_getByIdTest') {
	$id = $_GET['id'];
	echo "<p>$id</p>";
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::getContactById($id);
	exit;
}

if ($action == "emailList_update") {
	require_once(HTML_FOLDER . "classes/EmailList/loadModule.php");
	EmailListController::updateEmailList(true, true);
	exit;
}

// Email List End

// SalesRegions start

if ($action == "salesRegionsDashboard") {
	SalesRegionsController::salesRegionsDashboard();
	exit;
}

if ($action == "salesRegions_saveRegions") {
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);
	$regionsData = $parsed->regions;

	print_r($regionsData);

	$saveResult = SalesRegionsController::saveRegions($regionsData);

	echo json_encode($saveResult);
	exit;
}

if ($action == "salesRegions_saveStates") {
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);
	$statesData = $parsed->states;

	print_r($statesData);

	$saveResult = SalesRegionsController::saveStates($statesData);

	echo json_encode($saveResult);
	exit;
}

// SalesRegions end

// Encryption start

if ($action == "encryption_test") {
	require_once(HTML_FOLDER . "classes/Encryption/loadModule.php");
	EncryptionController::encryptionTest($_GET['testString']);
	exit;
}

// File Export start

if ($action == 'file_export_test') {
	require_once(HTML_FOLDER . "classes/FileExport/loadModule.php");
	FileExportController::fileExportTest();
	exit;
}

if ($action == 'file_export') {
	require_once(HTML_FOLDER . "classes/FileExport/loadModule.php");
	$fromSubmit = false;
	if ($_GET['submitted'] == 'true') {
		$fromSubmit = true;
	}
	FileExportController::fileExportPage($fromSubmit);
	exit;
}

if ($action == 'file_export_submit_request') {
	require_once(HTML_FOLDER . "classes/FileExport/loadModule.php");
	FileExportController::submitFileExportRequest();
	header('Location: '. CONTROLLER . '?m=file_export&submitted=true');
	exit;
}

// File Export end

// Email Start

if ($action == "email_shipNotificationTest") {
	require_once(HTML_FOLDER . "classes/Email/EmailController.php");
	EmailController::shipNotificationTest();
	exit;
}

if ($action == "email_shipNotificationLiveTest") {
	$zohoId = '';
	if ($_GET['zohoId']) {
		$zohoId = $_GET['zohoId'];
	}
	else {
		$zohoId = '835703000099047008';
	}
	echo "<h3>Zoho ID: $zohoId</h3>";
	$testRecord = $zohoObj->getShippedRecordData($zohoId);
	echo "<pre>";
	print_r($testRecord);
	echo "</pre>";
	$results = $ecomObj->emailShipNotification($testRecord);
	echo "<pre>";
	print_r($results);
	echo "</pre>";
	exit;
}

if ($action == "email_smtpTest") {
	require_once(HTML_FOLDER . "classes/Email/EmailController.php");
	EmailController::smtpTestEmail();
	exit;
}

// Email End

// Ecommerce Pages Begin
if ($action == 'editFreightCarriers') {
	require_once(HTML_FOLDER . "classes/Checkout/loadModule.php");
	CheckoutController::renderFreightCarrierPage();
	exit;
}

if ($action == "getFreightCarriers") {
	require_once(HTML_FOLDER . "classes/Checkout/loadModule.php");
	echo CheckoutController::getFreightCarriers();
	exit;
}

if ($action == "freightCarriers_save") {
	require_once(HTML_FOLDER . "classes/Checkout/loadModule.php");
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);
	$carriersData = $parsed->carriers;

	print_r($carriersData);

	$saveResult = CheckoutController::saveFreightCarriers($carriersData);

	echo json_encode($saveResult);

	// echo CheckoutController::saveFreightCarriers();
	exit;
}

if ($action == "freightCarriers_delete") {
	require_once(HTML_FOLDER . "classes/Checkout/loadModule.php");
	$carrierId = $_GET['carrierId'];
	if ($carrierId) {
		echo CheckoutController::deleteFreightCarrier($carrierId);
	}
	exit;
}


if ($action == 'ecommerce_checkout') {
	echo $ecomObj->ecom_checkout_page();
	exit;
}

if ($action == "populate_ecomm_shipped_log") {
	echo $ecomObj->populateLocalShippedDatabase($_GET['fromDate']);
	exit;
}

if ($action == 'ecommerce_checkout_submit') {
	$ecomObj->ecom_checkout_submit();
	// header('Location: '. CONTROLLER . '?m=ecommerce_checkout');
	exit;
}

if ($action == 'ecommerce_returns') {
	echo $ecomObj->ecom_returns_page();
	exit;
}

if ($action == 'ecommerce_returns_submit') {
	echo $ecomObj->ecom_returns_submit();
	header('Location: '. CONTROLLER . '?m=ecommerce_returns');
	exit;
}

if ($action == 'view_shipping_label') {
	$trackingNumber = $_GET['trackingNumber'];
	$filename = "$trackingNumber.pdf";
	$file = UPS_LABEL_PATH . $filename;
	header('Content-type: application/pdf');
	header('Content-Disposition: inline; filename="' . $filename . '"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');
	@readfile($file);
	exit;
}

if ($action == 'test_open_pdf') {
	// echo $worldshipObj->testOpenPdf($_GET['trackingNo']);
	$filename = '1Z09AY330390927666.pdf';
	$file = UPS_LABEL_PATH . $filename;
	header('Content-type: application/pdf');

	header('Content-Disposition: inline; filename="' . $filename . '"');

	header('Content-Transfer-Encoding: binary');

	header('Accept-Ranges: bytes');

	@readfile($file);
	exit;
}

if ($action == 'get_order_num_from_tracking') {
	echo $ecomObj->get_order_num_from_tracking($_POST['tracking_no']);
	exit;
}

if ($action == 'get_tracking_num_from_order') {
	echo $ecomObj->get_tracking_num_from_order($_POST['order_no']);
	exit;
}

if ($action == 'checkout_get_order_num_from_tracking') {
	echo json_encode($ecomObj->getOrderDataFromTracking($_POST['tracking_num']));
	exit;
}

if ($action == 'ecomm_checkout_get_asset_number_counts') {
	echo json_encode($ecomObj->getAssetNumberCounts($_POST['oNums']));
	exit;
}

if ($action == 'get_sp_nums_from_order_num') {
	echo $ecomObj->get_sp_nums_associated_with_order_num($_POST['order_no']);
	exit;
}

if ($action == 'get_sp_num_from_serial') {
	echo $ecomObj->get_sp_num_from_serial($_POST['serial_no']);
	exit;
}

if ($action == 'get_zoho_invoices') {
	echo $ecomObj->getZohoInvoicesAJAX($_POST['zoho_search']);
	exit;
}

if ($action == 'confirm_sp_exists') {
	echo $ecomObj->confirm_sp_exists($_POST['sp_no']);
	exit;
}

if ($action == 'get_expected_items') {
	$items = $ecomObj->getExpectedItems($_POST['orderNumber']);
	echo json_encode($items);
	exit;
}

if ($action == 'get_ecomm_open_order_expected_data') {
	$data = $ecomObj->getExpectedItemsAndTrackingNums($_POST['orderNumber']);
	echo json_encode($data);
	exit;
}

//Ecommerce Pages End

// Audit Start

if ($action == "new_device_receiving") {
	require_once(HTML_FOLDER . "classes/Audit/AuditController.php");
	AuditController::newDeviceReceiving();
	exit;
}

if ($action == "device_receiving_submit") {
	require_once(HTML_FOLDER . "classes/Audit/AuditController.php");
	$data = json_decode(str_replace('\\', '', file_get_contents('php://input')));
	// $poNumber = $data->poNumber;
	AuditController::deviceReceivingSubmit($data);
	exit;
}

if ($action == 'get_sku_by_identifier') {
	require_once(HTML_FOLDER . "classes/Audit/AuditController.php");
	$configCode = $_GET['identifier'];
	echo AuditController::getSkuByIdentifier($configCode);
	exit;
}

if ($action == 'verify_po_number') {
	require_once(HTML_FOLDER . "classes/Audit/AuditController.php");
	$poNumber = $_GET['poNumber'];
	echo AuditController::verifyPoNumber($poNumber);
	exit;
}

// Audit End

// Dropship start

if ($action == "dropship_ingest_test") {
	require_once(HTML_FOLDER . 'classes/Dropship/loadModule.php');
	// $assets = InventoryController::getInventoryCount();
	echo DropshipController::ingestInventoryTest();
	exit;

}

if ($action == "dropship_inventory") {
	require_once(HTML_FOLDER . 'classes/Dropship/loadModule.php');
	// $assets = InventoryController::getInventoryCount();
	echo DropshipController::inventoryPage();
	exit;

}

if ($action == "dropship_getInventoryItems") {
	require_once(HTML_FOLDER . 'classes/Dropship/loadModule.php');
	$assets = DropshipController::getInventoryCount();
	echo json_encode($assets, JSON_PRETTY_PRINT);
	exit;
}

if ($action == "dropship_fileUpload") {
	require_once(HTML_FOLDER . 'classes/Dropship/loadModule.php');
	echo DropshipController::fileUploadPage();
	exit;
}

if ($action == "dropship_perform_upload") {
	require_once(HTML_FOLDER . 'classes/Dropship/loadModule.php');

	echo DropshipController::ingestInventorySheet();
	exit;
}

// Dropship end

//Inventory start

$inventoryViews = array(
	'inventory',
	'repair_queue',
	'locked_inventory',
	'picked_ecomm',
	'picked_ebay_auction',
	'picked_wholesale'
);

if ($action == 'inventory_new_function_test') {
	require_once(HTML_FOLDER . 'classes/Inventory/InventoryController.php');
	$assets = InventoryController::getInventoryCount();
	echo "<pre>";
	// print_r($assets);
	echo json_encode($assets, JSON_PRETTY_PRINT);
	echo "</pre>";
	exit;
}

if ($action == "inventory_getInventoryItems") {
	require_once(HTML_FOLDER . 'classes/Inventory/InventoryController.php');
	$assets = InventoryController::getInventoryCount();
	echo json_encode($assets, JSON_PRETTY_PRINT);
	exit;
}

if ($action == 'inventory_new') {
	header('Location: '. CONTROLLER . '?m=inventory');
	exit;
}

if ($action == 'inventory') {
	require_once(HTML_FOLDER . 'classes/Inventory/InventoryController.php');
	// $assets = InventoryController::getInventoryCount();
	echo InventoryController::inventoryPage();
	exit;
}

if ($action == "inventory_getStatuses") {
	require_once(HTML_FOLDER . 'classes/Inventory/InventoryController.php');
	$statuses = InventoryController::getStatuses();
	echo json_encode($statuses, JSON_PRETTY_PRINT);
	exit;
}

// Handle redirect for old local wholesale URL.
if ($action == 'picked_local') {
	header('Location: '. CONTROLLER . '?m=picked_wholesale&v=local');
	exit;
}

if (in_array($action, $inventoryViews)) {
	$page = $action;
	$view = $_GET['v'];
	echo $invObj->inventoryPage($page, $view);
	exit;
}

if ($action =='get_inventory_items') {
	echo $invObj->getInventoryItems($_POST['page'], $_POST['view']);
	exit;
}

if ($action == 'get_asset_data') {
	echo $invObj->getItemData($_POST['asset'], $_POST['grade'], $_POST['page'], $_POST['view']);
	exit;
}

if ($action == 'get_locked_asset_data') {
	echo $invObj->getLockedItemData($_POST['poNumber'], $_POST['type']);
	exit;
}

if ($action == 'inventory_save_new_statuses') {
	echo $invObj->setNewStatuses($_POST);
	exit;
}

if ($action == 'locked_inventory_export') {
	if ($_POST['poNumber']) {
		echo $searchObj->export_bb_locks($_POST['poNumber'], true);
	}
	else {
		echo $invObj->exportAllLockedItems(true);
	}
	exit;
}

if ($action == 'export_all_locked_items') {
	$invObj->exportAllLockedItems();
	echo "<script type='text/javascript'>window.close()</script>";
	exit;
}

//Inventory end

// Metrics Start

if ($action == 'metrics_test') {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	MetricsController::metricsPage();
	exit;
}

if ($action == 'metrics_dashboard') {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	MetricsController::metricsPage();
	exit;
}

if ($action == 'region_metrics_dashboard') {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	$region = $_GET['region'];
	if (!$region) {
		$permissions = MetricsController::getRegionPermissions();
		$region = $permissions[0];
		if ($region) {
			header('Location:'.CONTROLLER.'?m=region_metrics_dashboard&region='.$region);
		}
		else {
			header('Location:'.CONTROLLER);
		}
	}
	MetricsController::regionalMetricsPage($region);
	exit;
}

if ($action == 'metrics_get_year_data') {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	$year = (string)$_GET['year'];
	echo json_encode(MetricsController::getYearData($year));
	exit;
}

if ($action == 'metrics_get_region_year_data') {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	$year = (string)$_GET['year'];
	$regionIdentifier = $_GET['region'];
	echo json_encode(MetricsController::getRegionalYearData($year, $regionIdentifier));
	exit;
}

if ($action == "metrics_get_region_projected_sales") {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	$regionIdentifier = $_GET['region'];
	echo json_encode(MetricsController::getRegionProjectedSales($regionIdentifier));
	exit;
}

if ($action == 'metrics_get_projected_sales') {
	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	echo json_encode(MetricsController::getProjectedSales());
	exit;
}

if ($action == 'metrics_get_mtd_comparisons') {
	$year = $_GET['year'];
	$month = $_GET['month'];
	$day = $_GET['day'];
	$otherYear = $_GET['otherYear'];

	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	echo json_encode(MetricsController::getMonthToDateComparisonData($year, $month, $day, $otherYear));
	// echo MetricsController::getMonthToDateComparisonData($year, $month, $day, $otherYear);
	exit;
}

if ($action == 'metrics_get_region_mtd_comparisons') {
	$year = $_GET['year'];
	$month = $_GET['month'];
	$day = $_GET['day'];
	$otherYear = $_GET['otherYear'];
	$region = $_GET['region'];

	require_once(HTML_FOLDER . 'classes/Metrics/MetricsController.php');
	echo json_encode(MetricsController::getRegionMonthToDateComparisonData($region, $year, $month, $day, $otherYear));
	exit;
}

if ($action == 'metrics_get_legacy_data') {
	echo file_get_contents(HTML_FOLDER . "classes/Metrics/staticData.json");
	exit;
}

// Metrics End

// Packing slips start

if ($action == 'tts_rma_packing_slip_test') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->generateTtsRmaPackingSlip($_GET['order_id'], 'I');
	exit;
}

if ($action == 'rma_packing_slip') {
	require_once('classes/class_packingslips.php');
	$options = array(
		'1' => 'F',
		'2' => 'I'
	);
	$destination = $options[$_GET['option']];
	$packingSlipObj = new PackingSlips;
	$slipName = $packingSlipObj->generateTtsRmaPackingSlip($_GET['orderId'], $destination);
	if ($destination == 'F') {
		$printer = SLIP_PRINTER;
		$packingSlipObj->send_printer($printer, $slipName);
		unlink($slipName);
	}
	echo "<script type='text/javascript'>window.close()</script>";
	exit;
}

if ($action == 'newegg_packing_slip_test') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->generateNeweggPackingSlip($_GET['order_id'], 'I');
	exit;
}

if ($action == 'ebay_packing_slip_test') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->generateEbayPackingSlip($_GET['order_id'], 'I');
	exit;
}

if ($action == 'backmarket_packing_slip_test') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->generateBackMarketPackingSlip($_GET['order_id'], 'I');
	exit;
}

if ($action == 'newegg_packing_slip') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->generateNeweggPackingSlip($_GET['order_id'], $_GET['dest']);
	exit;
}

if ($action == 'ebay_packing_slip') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->generateEbayPackingSlip($_GET['order_id'], $_GET['dest']);
	exit;
}

if ($action == 'merge_packing_slip_test_newegg') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->mergePackingSlipAndTrackingNumbers('295183609', 'newegg', array('1Z09AY330398880353'));
	exit;
}

if ($action == 'merge_packing_slip_test_ebay') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->mergePackingSlipAndTrackingNumbers('09-05867-01790', 'ebay', array('1Z09AY330398470402'));
	exit;
}

if ($action == 'merge_packing_slip_test2_newegg') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->mergePackingSlipAndTrackingNumbersV2('295183609', 'newegg', array('1Z09AY330398880353'));
	exit;
}

if ($action == 'merge_packing_slip_test2_ebay') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->mergePackingSlipAndTrackingNumbersV2('09-05867-01790', 'ebay', array('1Z09AY330398470402'));
	exit;
}

if ($action == 'print_merged_slip_test_newegg') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->printMergedPackingSlipAndShippingLabel('295183609', 'newegg', '1Z09AY330398880353');
	exit;
}

if ($action == 'print_merged_slip_test_ebay') {
	require_once('classes/class_packingslips.php');
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->printMergedPackingSlipAndShippingLabel('09-05867-01790', 'ebay', '1Z09AY330398470402');
	exit;
}

if ($action == 'merge_packing_slip_shipping_label') {
	require_once('classes/class_packingslips.php');
	$orderId = $_GET['order_id'];
	$channel = $_GET['channel'];
	$trackingNum = $_GET['tracking_number'];
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->getMergedPackingSlipAndShippingLabel($orderId, $channel, $trackingNum);
	exit;
}

if ($action == 'reprint_packing_slip') {
	require_once('classes/class_packingslips.php');
	$orderId = $_POST['order_id'];
	$channel = $_POST['channel'];
	$packingSlipObj = new PackingSlips;
	$packingSlipObj->printPackingSlips($orderId, $channel, false, true);
	exit;
}


// Packing slips end

// Executive start

if ($action == 'edit_shipping_boxes') {
	echo $executiveObj->editShippingBoxesPage();
	exit;
}

if ($action == 'save_new_shipping_box') {
	echo $executiveObj->saveNewBox($_POST);
	exit;
}

if ($action == 'save_shipping_box') {
	echo $executiveObj->saveBoxEdits($_POST);
	exit;
}

if ($action == 'delete_shipping_box') {
	echo $executiveObj->deleteBox($_POST['id']);
	exit;
}

// Executive end

// Service Requests Start

if ($action == 'open_service_requests') {
	require_once(HTML_FOLDER . "classes/RMA/RMAService.php");
	echo RMAService::serveOpenServiceRequestsPage();
	exit;
}

if ($action == 'completed_service_requests') {
	require_once(HTML_FOLDER . "classes/RMA/RMAService.php");
	echo RMAService::serveCompletedServiceRequestsPage();
	exit;
}

if ($action == 'get_service_requests') {
	require_once(HTML_FOLDER . "classes/RMA/RMAService.php");
	echo json_encode(RMAService::getOpenServiceRequests($_POST['type']));
	exit;
}

if ($action == 'get_completed_service_requests') {
	require_once(HTML_FOLDER . "classes/RMA/RMAService.php");
	echo json_encode(RMAService::getCompletedServiceRequests($_POST['startDate'], $_POST['endDate']));
	exit;
}

if ($action == 'save_service_request_changes') {
	require_once(HTML_FOLDER . "classes/RMA/RMAService.php");
	echo RMAService::saveServiceRequestChanges($_POST);
	exit;
}

if ($action == 'ecomm_service_requests') {
	require_once(HTML_FOLDER . "classes/ServiceRequests.php");
	require_once(HTML_FOLDER . "classes/ServiceRequests/BackmarketServiceRequest.php");
	$serviceRequests = new ServiceRequests;
	$requests = $serviceRequests->getBackMarketServiceRequests();
	// echo "<pre>";
	// print_r($requests);
	// echo "</pre>";
	foreach ($requests as $request) {
		$orderId = $request->id;
		$requestDetails = new BackmarketServiceRequest($serviceRequests->getRequestDetails($orderId, 'backmarket'));
		// echo "<pre>";
		// print_r($requestDetails);
		// echo "</pre>";
		$requestDetails->performDatabaseInsertions();

	}
	// echo "<pre>";
	// print_r($serviceRequests->getRequestDetails('120063', 'backmarket'));
	// echo "</pre>";

	// $request = new BackmarketServiceRequest($serviceRequests->getRequestDetails('120063', 'backmarket'));
	// $request->performDatabaseInsertions();
	exit;
}

// Buybacks Start

if ($action == "buybacks_active_buybacks") {
	require_once(HTML_FOLDER . "classes/Buybacks/BuybacksController.php");
	BuybacksController::buybacksDashboard();
	exit;
}

if ($action == "buybacks_fetchActiveBuybacks") {
	require_once(HTML_FOLDER . "classes/Buybacks/BuybacksController.php");
	echo json_encode(BuybacksController::getActiveBuybacks());
	exit;
}

if ($action == "buybacks_refreshActiveBuybacks") {
	require_once(HTML_FOLDER . "classes/Buybacks/BuybacksController.php");
	BuybacksController::refreshActiveBuybacks();
	exit;
}

if ($action == "buybacks_open_quotes") {
	header('Location: '. CONTROLLER . '?m=open_quotes');
	// require_once(HTML_FOLDER . "classes/Buybacks/BuybacksController.php");
	// BuybacksController::buybacksDashboard();
	exit;
}

if ($action == "buybacks_refresh_open_quotes") {
	require_once(HTML_FOLDER . "classes/Buybacks/BuybacksController.php");
	BuybacksController::refreshOpenBuybacks();
	// echo $zohoObj->getOpenQuotes();
	exit;
}

if ($action == "buybacks_saveChanges") {
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);

	require_once(HTML_FOLDER . "classes/Buybacks/BuybacksController.php");
	BuybacksController::saveBuybackChanges($parsed);
	exit;
}

// Buybacks End

// Open Quotes Start

if ($action == "open_quotes") {
	require_once(HTML_FOLDER . "classes/OpenQuotes/OpenQuotesController.php");
	OpenQuotesController::openQuotesDashboard();
	exit;
}

if ($action == 'open_quotes_fetch') {
	require_once(HTML_FOLDER . "classes/OpenQuotes/OpenQuotesController.php");
	echo json_encode(OpenQuotesController::getOpenQuotes());
	exit;
}

if ($action == "open_quotes_refresh") {
	require_once(HTML_FOLDER . "classes/OpenQuotes/OpenQuotesController.php");
	OpenQuotesController::refreshOpenQuotes();
	exit;
}

if ($action == "open_quotes_save_changes") {
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);
	require_once(HTML_FOLDER . "classes/OpenQuotes/OpenQuotesController.php");
	OpenQuotesController::saveOpenQuoteChanges($parsed);
	exit;
}

// Open Quotes End

// Purchase Orders start

if ($action == 'inbound_inventory') {
	require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	PurchaseOrdersController::inboundInventoryPage();
	exit;
}

if ($action == "purchaseOrders_get_inbound") {
	require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	PurchaseOrdersController::refreshPurchaseOrdersFromZoho();
	exit;
}

if ($action == 'purchaseOrders_getRecords') {
	require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	$records = PurchaseOrdersController::getPurchaseOrderRecords();
	// echo "<pre>";
	// print_r($records);
	// echo "</pre>";
	echo json_encode($records);
	exit;
}

if ($action == "purchaseOrders_save_changes") {
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);
	require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	PurchaseOrdersController::saveChanges($parsed);
	exit;
}

if ($action == "purchaseOrders_getPermissions") {
	require_once(HTML_FOLDER . "classes/PurchaseOrders/PurchaseOrdersController.php");
	echo PurchaseOrdersController::getPermissions();
	exit;
}

// Purchase Orders end

//Open Orders start

if ($action == "open_orders_new_update_test") {
	OpenOrdersController::updateOpenOrders();
	exit;
}

if ($action == "open_orders_new_get_test") {
	$openOrders = OpenOrdersController::getOpenOrders();
	echo "<pre>";
	echo json_encode($openOrders, JSON_PRETTY_PRINT);
	echo "</pre>";
	exit;
}

if ($action == "open_orders_new") {
	OpenOrdersController::openOrdersPage();
	exit;
}

if ($action == "open_orders_update") {
	OpenOrdersController::updateOpenOrders();
	exit;
}

if ($action == "open_orders_fetch") {
	$data = OpenOrdersController::getOpenOrdersAndStatuses();
	echo json_encode($data, JSON_PRETTY_PRINT);
	exit;
}

if ($action == "open_orders_saveChanges") {
	$_POST = str_replace('\\', '', file_get_contents('php://input'));
	$parsed = json_decode($_POST);
	print_r($parsed);

	echo OpenOrdersController::saveOpenOrderChanges($parsed);
	exit;
}

if ($action == 'open_orders') {
	OpenOrdersController::openOrdersPage();
	// echo $openOrdersObj->ttsOpenOrdersPage();
	exit;
}

if ($action == 'ecommerce_open_orders') {
	echo $openOrdersObj->ecommerceOpenOrdersPage();
	exit;
}

if ($action == 'get_ecommerce_open_orders') {
	echo $openOrdersObj->getEcommOpenOrders($_GET['debug']);
	exit;
}

if ($action == 'zoho_get_records_test') {
	echo $openOrdersObj->updateOpenOrders();
	exit;
}

if ($action == 'zoho_get_records') {
	// echo json_encode($zohoObj->getSearchRecordsProducts());
	echo json_encode($openOrdersObj->updateOpenOrders());
	exit;
}

if ($action == 'get_open_order_statuses') {
	echo $openOrdersObj->getStatuses();
	exit;
}

if ($action == 'update_and_retrieve_local_open_orders') {
	echo $openOrdersObj->updateLocalRecordDataFromZoho($_POST);
	exit;
}

if ($action == 'save_open_order_single') {
	echo $openOrdersObj->saveSingle($_POST);
	exit;
}

if ($action == 'save_open_order_multiple') {
	echo $openOrdersObj->saveMultiple($_POST['orders']);
	exit;
}

if ($action == 'save_ecommerce_open_order_single') {
	echo $openOrdersObj->saveSingleEcomm($_POST);
	exit;
}

if ($action == 'save_ecommerce_open_order_multiple') {
	echo $openOrdersObj->saveMultipleEcomm($_POST['orders']);
	exit;
}

if ($action == 'print_packing_slip') {
	echo $openOrdersObj->printPackingSlip($_POST['channel'], $_POST['order_id']);
	exit;
}

if ($action == "mpdf_test") {
	$path=__DIR__ . HTML_FOLDER.'tmp';
	$filename = 'printtest.pdf';
	$filepath = "$path/$filename";
	require_once __DIR__ . '/vendor/autoload.php';
	echo "Test";
	$mpdf = new \Mpdf\Mpdf();
	echo "<p>Constructor Done</p>";
	$file = file_get_contents('templates/open_orders/packing_slips/ebay_packing_slip.html');
	// $mpdf->WriteHTML("<h1>Hello World!</h1>");
	$mpdf->WriteHTML($file);
	echo "<p>HTML Written</p>";
	// echo "Test";
	// $mpdf->Output("tmp/tmp.pdf", \Mpdf\Output\Destination::FILE);
	$mpdf->Output();
	echo "<p>Outputted</p>";
	$printer = ECOMM_FULFILLMENT_INVENTORY_CAGE_PRINTER;
	echo "<p>Printer Selected</p>";
	$frmwkObj->send_printer($printer, 'tmp/tmp.pdf');
	echo "<p>Print Job Sent</p>";
	// echo "Test";
	exit;
}

//Open Orders end

// Shipped Orders start

if ($action == 'shipped_orders') {
	echo $shipLogObj->shipLogPage('tts');
	exit;
}

if ($action == 'ecomm_shipped_orders') {
	echo $shipLogObj->shipLogPage('ecomm');
	exit;
}

if ($action == 'get_tts_ship_log') {
	echo $shipLogObj->getTtsShipLog($_POST['salespersons'], $_POST['startDate'], $_POST['endDate']);
	exit;
}

if ($action == 'get_ecomm_ship_log') {
	echo $shipLogObj->getEcommShiplog($_POST['startDate'], $_POST['endDate']);
	exit;
}

if ($action == 'debug_get_ship_log') {
	echo "<p>Getting Ship Log</p>";
	echo $shipLogObj->getEcommShiplog($_GET['startDate'], $_GET['endDate'], true);
	exit;
}

if ($action == 'populate_ship_log') {
	$startPage = (int)$_GET['startPage'];
	$numPages = (int)$_GET['numPages'];
	echo $shipLogObj->populateShipLog($startPage, $numPages);
	exit;
}

if ($action == 'update_order_ship_date') {
	echo $shipLogObj->updateShipDate($_POST['zoho_id'], $_POST['ship_date']);
	exit;
}

if ($action == 'get_updated_zoho_ship_date') {
	echo $shipLogObj->getUpdatedZohoShipDate($_POST['zoho_id']);
	exit;
}

if ($action == 'zoho_refresh_record') {
	echo "Action is zoho_refresh_record\n";
	if ($_GET['zohoId']) {
		echo "Submitted is zohoId\n";
		echo $shipLogObj->getUpdatedZohoInfo($_GET['zohoId']);
	}
	elseif ($_GET['mtsNumber']) {
		echo "Submitted is mtsNumber\n";
		echo $shipLogObj->getNewZohoInfo($_GET['mtsNumber']);
	}
	exit;
}

// Ship Log end

// Deductions Start

if ($action == 'deductions') {
	require_once(HTML_FOLDER . "classes/Deductions/DeductionsService.php");
	Deductions::renderDeductionsPage();
	exit;
}

if ($action == 'getDeductedSkus') {
	require_once(HTML_FOLDER . "classes/Deductions/DeductionsService.php");
	echo json_encode(Deductions::getDeductedSkus());
	exit;
}

if ($action == 'addToDeductions') {
	require_once(HTML_FOLDER . "classes/Deductions/DeductionsService.php");
	$module = $_GET['module'];
	$view = $_GET['view'];
	$id = $_GET['id'];
	$channel = $_GET['channel'];
	echo Deductions::addToDeductions($module, $view, $id, $channel);
	exit;
}

if ($action == 'removeFromDeductions') {
	require_once(HTML_FOLDER . "classes/Deductions/DeductionsService.php");
	$view = $_GET['view'];
	$id = $_GET['id'];
	Deductions::removeFromDeductions($view, $id);
	exit;
}

// Deductions End

// Constant Contact API Start

if ($action == "constantContactAuthTest") {
	require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");
	ConstantContactAPI::getAuthLink();
	exit;
}

if ($action == "constantContactAuthVerify") {
	echo "<pre>";
	print_r($_GET);
	echo "</pre>";
	$code = $_GET['code'];
	require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");
	$result = ConstantContactAPI::verifyAuthCode($code);
	if (!$result) {
		echo "<h3>Fetching and saving auth code failed.</h3>";
	}
	else {
		echo "<h3>Success!</h3>";
	}
	// require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");
	// ConstantContactAPI::getAuthLink();
	exit;
}

if ($action == "constantContactTestRefreshToken") {
	require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");
	ConstantContactAPI::refreshToken();
	exit;
}

if ($action == "constantContact_getContacts") {
	require_once(HTML_FOLDER . "apis/constantContact/ConstantContactAPI.php");

	$parameters = array();
	if ($_GET['updated_after']) {
		$parameters['updated_after'] = $_GET['updated_after'];
	}
	if ($_GET['limit']) {
		$parameters['limit'] = (int)$_GET['limit'];
	}
	ConstantContactAPI::getContactsCollection($parameters);
	exit;
}

// Constant Contact API End

// Shopify start

if ($action == 'get_shopify_product') {
	require_once(HTML_FOLDER . "apis/shopify/loadModule.php");
	$productId = '';
	$variantId = '';
	$productId = trim($_GET['p'], " \t\n\r\0\x0B'\"");
	if ($_GET['v']) {
		$variantId = trim($_GET['v'], " \t\n\r\0\x0B'\"");
	}
	echo ShopifyApi::getProduct($productId, $variantId);
	// echo $shopifyObj->getProduct();
	exit;
}

if ($action == 'get_shopify_products') {
	require_once(HTML_FOLDER . "apis/shopify/loadModule.php");
	echo ShopifyApi::getProductVariantsList();
	// echo $shopifyObj->getProductVariantsList();
	exit;
}
// Shopify end

// Ebay API Start

// if ($action == "get_ebay_bearer_token") {
// 	echo $ebayApiObj->getBearerToken();
// 	exit;
// }

if ($action == "get_ebay_order_data") {
	$result = $ebayApiObj->getOrder($_GET['order_id']);
	echo "<pre>";
	print_r(json_decode($result));
	echo "</pre";
	exit;
}

if ($action == "ebay_login_accept") {
	echo $ebayApiObj->handleLogin();
	exit;
}

if ($action == "ebay_get_open_orders") {
	echo $ebayApiObj->getUnfulfilledOrders();
	exit;
}

if ($action == "ebay_get_returns") {
	$ebayApiObj->getRefundHistory();
	exit;
}

if ($action == 'ship_ebay_orders') {
	if ($_GET['order_ids']) {
		$orderIds = explode(',', $_GET['order_ids']);
	}
	else if ($_POST['order_ids']) {
		$orderIds = explode(',', $_POST['order_ids']);
	}
	$worldshipObj->shipEbayOrders($orderIds);
	exit;
}


// Ebay API End

// Newegg API Start

if ($action == "newegg_api_test") {
	$neweggApiObj->apiTest();
	exit;
}

if ($action == "newegg_get_returns") {
	$neweggApiObj->getRefundHistory();
	exit;
}

if ($action == 'ship_newegg_orders') {
	if ($_GET['order_ids']) {
		$orderIds = explode(',', $_GET['order_ids']);
	}
	else if ($_POST['order_ids']) {
		$orderIds = explode(',', $_POST['order_ids']);
	}
	$worldshipObj->shipNeweggOrders($orderIds);
	exit;
}

// Newegg API End

// Amazon API start

if ($action == 'amazon_api_test') {
	//echo "testsetsete";
	require_once(HTML_FOLDER . 'apis/amazon/class_amazon_api.php');
	$version = "v2";
	$sandbox = false;
	$debug = false;
	$amazonApi = new AmazonAPI($version, $sandbox, $debug);	
	$amazonApi->apiTest();
	exit;
}

if ($action == 'amazon_api_test_2') {
	require_once(HTML_FOLDER . 'apis/amazon/AmazonAPI.php');
	$version = "v2";
	$sandbox = true;
	$debug = true;
	$amazonApi = new AmazonAPIV2($version, $sandbox, $debug);
	$amazonApi->testAmazonApi();
	exit;
}

if ($action == 'amazon_mws_test') {
	// require_once(HTML_FOLDER . 'apis/amazon/AmazonMWS.php');
	$amazonMWS = new AmazonMWS();
	$orders = $amazonMWS->getOpenOrders();
	echo "<pre>";
	print_r($orders);
	echo "</pre>";
	exit;
}

if ($action == 'mws_list_financial_events') {
	require_once(HTML_FOLDER . 'apis/amazon/AmazonMWS.php');
	$amazonMWS = new AmazonMWS();
	$events = $amazonMWS->listFinancialEvents();
	echo "<pre>";
	print_r($events);
	// print_r($events->ListFinancialEventsResult->FinancialEvents->RefundEventList);
	echo "</pre>";
	exit;
}

if ($action == "mws_get_month_refunds") {
	require_once(HTML_FOLDER . 'apis/amazon/AmazonMWS.php');
	$amazonMWS = new AmazonMWS();
	$events = $amazonMWS->getMonthRefunds($_GET['year'], $_GET['month']);
	// echo "<pre>";
	// print_r($events);
	// echo "</pre>";
	exit;
}

if ($action == "mws_get_all_refunds") {
	require_once(HTML_FOLDER . 'apis/amazon/AmazonMWS.php');
	$amazonMWS = new AmazonMWS();
	$amazonMWS->getAllRefunds();
	exit;
}

// Amazon API end

// Back Market Start

if ($action == "get_back_market_orders") {
	echo $backmarketObj->getAllUnfulfilledOrders();
	exit;
}

if ($action == "get_back_market_order") {
	$data = $backmarketObj->getOrder($_GET['o']);
	$decodedData = json_decode($data);
	echo "<pre>";
	print_r($decodedData);
	echo "</pre>";
	// echo "<p></p>";
	// echo $decodedData->order_id;
	// echo "<p></p>";
	// echo $decodedData->price;
	// echo "<p></p>";
	// echo $decodedData->date_creation;
	// echo "<p></p>";
	// echo print_r($decodedData->orderlines);
	// echo "<p></p>";
	// echo $decodedData->tracking_number;
	exit;
}

if ($action == 'validate_back_market_order') {
	if ($_GET['order_id']) {
		$orderId = $_GET['order_id'];
	}
	else if ($_POST['order_id']) {
		$orderId = $_POST['order_id'];
	}
	$backmarketObj->validateOrder($orderId);
	exit;
}

if ($action == 'validate_back_market_orders') {
	if ($_GET['order_ids']) {
		$orderIds = explode(',',$_GET['order_ids']);
	}
	else if ($_POST['order_ids']) {
		$orderIds = explode(',',$_POST['order_ids']);
	}
	foreach ($orderIds as $orderId) {
		// echo json_encode($orderIds);
		$backmarketObj->validateOrder($orderId);
	}
	exit;
}

if ($action == 'ship_back_market_orders') {
	if ($_GET['order_ids']) {
		$orderIds = explode(',',$_GET['order_ids']);
	}
	else if ($_POST['order_ids']) {
		$orderIds = explode(',',$_POST['order_ids']);
	}
	$worldshipObj->shipBackMarketOrders($orderIds);
	exit;
}

if ($action == 'cancel_back_market_order') {
	$backmarketObj->cancelOrder($_POST['order_id']);
	exit;
}

if ($action == 'get_back_market_order_history') {
	$dbObj->resetAutoIncrement('ecomm_ship_log');
	$orders = $backmarketObj->getOrderHistory();
	$sql = "SELECT `id` FROM `ecomm_sales_channels` WHERE `identifier`='back_market' LIMIT 1;";
	$result = $dbObj->db_query($sql, 'select-single', true);
	$channelId = $result['id'];
	foreach ($orders as $order) {
		$orderId = $order->order_id;
		if (!$order->date_shipping) {
			// echo "<pre>";
			// print_r($order);
			// echo "</pre>";
			$sql = "DELETE FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId';";
			$dbObj->db_query($sql, 'delete', true);
			$dbObj->resetAutoIncrement('ecomm_ship_log');
		}
		else {
			$invoiceDate = DateTime::createFromFormat(DATE_ATOM, $order->date_creation)->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
			$shipDate = DateTime::createFromFormat(DATE_ATOM, $order->date_shipping)->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
			$itemStatus = (int)$order->orderlines[0]->state;
			$subtotal = (float)$order->price;
			$price = (float)$order->orderlines[0]->price;
			$sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
			$result = $dbObj->db_query($sql, 'select-single', true);
			$ecommId = $result['id'];
			if ($ecommId) {
				$sql = "UPDATE `ecomm_shipping_details` SET `ship_date`='$shipDate' WHERE `ecomm_id`='$ecommId';";
				$dbObj->db_query($sql, 'update', true);
			}
			else {
				$shipMethod = $order->shipper;
				$trackingNumber = $order->tracking_number;
				$sku = $order->orderlines[0]->listing;
				$quantity = $order->orderlines[0]->quantity;

				echo "<h1>Performing previously-unseen order inserts</h1>";

				$sql = "INSERT IGNORE INTO `ecomm_back_market_listings`(`sku`) VALUES ('$sku');";
				echo "<p>$sql</p>";
				$dbObj->db_query($sql, 'insert', true);
				$dbObj->resetAutoIncrement('ecomm_back_market_listings');

				$sql = "INSERT IGNORE INTO `ecomm_ship_log`(`order_id`, `channel_id`, `invoice_date`, `subtotal`) VALUES ('$orderId', '$channelId', '$invoiceDate', '$subtotal');";
				echo "<p>$sql</p>";
				$dbObj->db_query($sql, 'insert', true);
				$dbObj->resetAutoIncrement('ecomm_ship_log');

				$sql = "SELECT `id` FROM `ecomm_ship_log` WHERE `order_id`='$orderId' AND `channel_id`='$channelId' LIMIT 1;";
				$result = $dbObj->db_query($sql, 'select-single', true);
				$ecommId = $result['id'];

				$sql = "INSERT IGNORE INTO `ecomm_shipping_details`(`ecomm_id`, `ship_date`, `ship_method`) VALUES ('$ecommId', '$shipDate', '$shipMethod');";
				echo "<p>$sql</p>";
				$dbObj->db_query($sql, 'insert', true);

				$sql = "INSERT IGNORE INTO `ecomm_tracking_numbers`(`ecomm_id`, `tracking_number`) VALUES ('$ecommId', '$trackingNumber');";
				echo "<p>$sql</p>";
				$dbObj->db_query($sql, 'insert', true);

				$sql = "INSERT IGNORE INTO `ecomm_back_market_listings_shipped`(`item_id`, `ecomm_id`, `quantity`) VALUES ((SELECT `id` FROM `ecomm_back_market_listings` WHERE `sku`='$sku' LIMIT 1), '$ecommId', '$quantity');";
				echo "<p>$sql</p>";
				$dbObj->db_query($sql, 'insert', true);

				echo "<p>Done!</p>";
				echo "<hr />";
			}
			if ($itemStatus > 3) {
				$returnDate = DateTime::createFromFormat(DATE_ATOM, $order->date_modification)->setTimezone(new DateTimeZone('UTC'))->format('Y-m-d H:i:s');
				// echo "<h1>Returned order</h1>";
				// echo "<p>Order ID: $orderId</p>";
				// echo "<p>Ship Date: $shipDate</p>";
				// echo "<p>Return date: $returnDate</p>";
				// echo "<hr />";
				if ($ecommId) {
					$sql = "INSERT IGNORE INTO `ecomm_return_log`(`ecomm_id`, `return_date`, `return_amount`) VALUES ('$ecommId', '$returnDate', '$price') ON DUPLICATE KEY UPDATE `return_date`='$returnDate', `return_amount`='$price';";
					$dbObj->db_query($sql, 'insert', true);
				}
			}
		}
	}
	exit;
}

// Back Market End

// Zoho test start

// if ($action == "zoho_get_order") {
// 	$zohoObj->getShippedRecordData($_GET['order']);
// 	exit;
// }

if ($action == "zoho_getRecentlyModifiedContacts") {
	echo "<p>Starting to get recently modified contacts</p>";
	$contacts = $zohoObj->getContactsModifiedSinceDate();
	foreach ($contacts as $contact) {
		echo "<pre>";
		print_r($contact->jsonify());
		echo "</pre>";
	}
	exit;
}

if ($action == "zoho_getRecentlyModifiedAccounts") {
	$zohoObj->getAccountsModifiedSinceDate();
	exit;
}

if ($action == "zoho_getRecentlyModifiedLeads") {
	$zohoObj->getLeadsModifiedSinceDate();
	exit;
}

if ($action == "zoho_get_record_by_mts_number") {
	$record = $zohoObj->searchInvoiceByMTSNumber($_GET['mtsNumber']);
	echo "<pre>";
	print_r($record);
	echo "</pre>";
	exit;
}

if ($action == "zoho_search_by_field") {
	$field = $_GET['field'];
	$value = $_GET['value'];
	$zohoObj->searchInvoiceByField($field, $value);
	exit;
}

if ($action == "zohoTest_getUserDetails") {
	$zohoId = $_GET['zohoId'];
	$record = $zohoObj->getUserDetails($zohoId);
	echo "<pre>";
	print_r($record);
	echo "</pre>";
	exit;
}

if ($action == "zohoTest_getContactDetails") {
	$zohoId = $_GET['zohoId'];
	$record = $zohoObj->getContactDetails($zohoId);
	echo "<pre>";
	print_r($record);
	echo "</pre>";
	exit;
}

if ($action == 'zohoTest_getShippedRecordData') {
	$zohoId = $_GET['zohoId'];
	$record = $zohoObj->getShippedRecordData($zohoId);
	echo "<pre>";
	print_r($record);
	echo "</pre>";
	exit;
}


// Zoho test end

// Order Detail start
if ($action == "order_detail" && substr($_GET['oNum'], 0, 2) == 'MS') {
	header('Location:'.CONTROLLER.'?m=ms_order_detail&oNum='.$_GET['oNum']);
	exit;
}

if ($action == "ms_order_detail") {
	require_once(HTML_FOLDER . "classes/OrderDetails/OrderDetailsService.php");
	$orderDetailsService = new OrderDetailsService;
	echo $orderDetailsService->orderDetailNew($_GET['oNum']);
	// echo $adminObj->orderDetailNew($_GET['oNum']);
	exit;
}

if ($action == "order_detail_submit") {
	require_once(HTML_FOLDER . "classes/OrderDetails/OrderDetailsService.php");
	$orderDetailsService = new OrderDetailsService;
	$orderDetailsService->orderDetailSubmit($_GET['oNum'], $_POST);
	exit;
}

// Order Detail end

# ACTION: ORDER DETAIL LOGIC
if (in_array($action, array('order_detail', 'tracking', 'ups_void', 'authorize','reprint_refurb_label'))) {
        $dd_data['PAYFLOW_TOTAL'] = $adminObj->get_payflow_totals();
	$adminObj->order_detail(
		$_GET['oNum'], $_GET['tracking'], $action, $_POST['submit_action'], $_POST, $dd_data
	);
	exit;
}

# ACTION: CUSTOMER DETAIL LOGIC
if (in_array($action, array('customer_detail', 'customer_submit'))) {
        //if we're returning from multi order popup read cShipService from $_GET to $_POST array
        if ($_GET['cShipService']){
            for ($i=0;$i<=$_GET['create']-1;$i++){
                $_POST['cShipService'][$i] = $_GET['cShipService'];
            }
        }
        $dd_data['PAYFLOW_TOTAL'] = $adminObj->get_payflow_totals();
	$adminObj->customer_detail(
		$_GET['cString'], $_POST['submit_action'], $_GET['create'], $_POST, $dd_data, $history
	);
	exit;
}

# ACTION: CREATE REPAIR
if ($action == 'create_repair'){
    if ($_POST['order_number']){
        $order_no = $_POST['order_number'];
    }else{
        $order_no = $_GET['oNum'];
    }
    if (substr($order_no, 0, strlen(ORDER_NUM_PREFIX)) == ORDER_NUM_PREFIX || substr($order_no, 0, strlen(REFURB_PREFIX)) == REFURB_PREFIX){
        $order_no = substr($order_no,strlen(ORDER_NUM_PREFIX));
    }
    $order = $orderObj->get_data($order_no);
    if ($order['oID'] == $order_no){
        //$tia_data = $gsxObj->get_comptia_codes();
        $adminObj->create_repair($order);
    }else{
        $adminObj->add_items(array("ERROR_MESSAGE" => "Invoice Not Found","VALUE" => $_POST["order_number"]));
    }
    exit;
}

#ACTION: SUBMIT REPAIR
if ($action == 'submit_repair'){
    if ($_POST['new_item']){
        $adminObj->add_items(array("ERROR_MESSAGE" => "","VALUE" => ""));
    }else{
        $adminObj->submit_repair();
    }
    exit;
}

#ACTION: STOCK ORDER
if ($action == 'stock_order'){
    $adminObj->stock_order();
    exit;
}

if ($action == 'authorizations'){
    $adminObj->authorizations($_GET['oNum']);
    exit;
}


switch ($action) {
										#**********************
	case 'getimage':					# ACTION: SHOW UPS LABEL
		if (!$frmwkObj->get_image(UPS_LABEL_PATH . basename($_GET['tracking']) . '.pdf', 'application/pdf')) {
			$frmwkObj->error_page(MISSING_RESULTS);
		}
	exit;
										#**************
	case 'print':						# ACTION: PRINT
		if ($_GET['tracking'] && $_GET['print'] == 'label') {
			$file = UPS_LABEL_PATH . $_GET['tracking'] . '.pdf';
			if ($frmwkObj->send_printer(UPS_LABEL_PRINTER, $file)) {
				$frmwkObj->goToURL(CONTROLLER . '?m=order_detail&oNum=' . $_GET['oNum']);
			}
		} else if ($_GET['oNum'] &&  $_GET['print'] == 'checkin') {
			if ($data = $orderObj->get_data($_GET['oNum'])) {
                                if ($_SESSION['printer_id'] == 4){
                                    $printer = constant('FRONT_DESK_PRINTER');
                                }else{
                                    $printer = constant('SLIP_PRINTER');
                                }
				if ($orderObj->print_slip($_GET['oNum'], $printer, 'checkin', $_GET['viewonly'])) {
					$frmwkObj->goToURL(CONTROLLER . '?m=order_detail&oNum=' . $_GET['oNum']);
				}
			}
			} else if ($_GET['oNum'] &&  $_GET['print'] == 'diag') {
			if ($data = $orderObj->get_data($_GET['oNum'])) {
				if ($orderObj->print_slip($_GET['oNum'], SLIP_PRINTER, 'diag', $_GET['viewonly'])) {
					$frmwkObj->goToURL(CONTROLLER . '?m=order_detail&oNum=' . $_GET['oNum']);
				}
			}
		} else if ($_GET['oNum'] &&  $_GET['print'] == 'packing') {
			if ($orderObj->print_slip($_GET['oNum'], SLIP_PRINTER, 'packing', $_GET['viewonly'])) {
				$frmwkObj->goToURL(CONTROLLER . '?m=order_detail&oNum=' . $_GET['oNum']);
			}
		}
	exit;
										#**********************
	case 'edit_feedback':				# ACTION: EDIT FEEDBACK
		$adminObj->edit_feedback();
	exit;
										#**************************
	case 'edit_skus':					# ACTION: EDIT SKU MAPPINGS
		$adminObj->edit_skus();
	exit;
										#**************************
	case 'edit_clients':				# ACTION: EDIT BUSS CLIENTS
		$adminObj->edit_clients();
	exit;
										#*************************
	case 'receiving':					# ACTION: RECEIVING STEP 1
		echo $frmwkObj->parse(TEMPLATE, array('BODY' => $adminObj->parse_receiving_form($data), "TITLE" => "Receiving"));
	exit;
										#*************************
	case 'receiving_submit':			# ACTION: RECEIVING STEP 2
		echo $adminObj->receiving($_POST['oNum'], $_POST);
	exit;

    case 'refurbishing':					# ACTION: REFURBISHING STEP 1
		echo $frmwkObj->parse(TEMPLATE, array('BODY' => $adminObj->parse_refurbishing_form(), "TITLE" => "Refurbishing"));
	exit;

    case 'audit':					# ACTION: RECEIVING STEP 1
		echo $frmwkObj->parse(TEMPLATE, array('BODY' => $adminObj->parse_audit_form($data), "TITLE" => "Audit"));
	exit;

    case 'checkout':					# ACTION: REFURBISHING STEP 1
		echo $frmwkObj->parse(TEMPLATE, array('BODY' => $adminObj->parse_checkout_form(), "TITLE" => "Checkout"));
    exit;

    case 'getTrackingNo':					# get Tracking# ajax call
        echo $adminObj->get_tracking_no($_GET['invoiceId']);
    exit;

    case 'ms_checkout':					# ACTION: REFURBISHING STEP 1
        echo $frmwkObj->parse(TEMPLATE, array('BODY' => $adminObj->parse_ms_checkout_form()));
	exit;

    case 'checkout_submit':
        $adminObj->checkout_submit();
    exit;

    case 'ms_checkout_submit':
        $adminObj->ms_checkout_submit();
    exit;

    case 'refurbish_submit':
        echo $adminObj->refurbishing($_POST);
										#***********************************
	case 'receiving_count_submit':		# ACTION: IN/OUT COUNTER AJAX SUBMIT
		if ($_POST['carrier'] && $_POST['quantity']) {
			$searchObj->insert_receiving($frmwkObj->format_date('db_date'), $_POST['carrier'], $_POST['quantity']);
			echo 'DONE';
		}
	exit;
										#**********************
	case 'search':						# ACTION: SEARCH SUBMIT
		if (!list($results, $youSearched) = $searchObj->run(
				$search, $query, $_GET['cStatus'], $_GET['toDate'], $_GET['fromDate'], $_GET['dt']
			)
		) {
			$output = '<p class="error">' . MISSING_RESULTS;
		} else {
			$output = $searchObj->display($search, $query, $_GET, $results, $youSearched);
		}
                $dd_data['PAYFLOW_TOTAL'] = $adminObj->get_payflow_totals();
		echo $frmwkObj->parse(TEMPLATE, array('BODY' => $frmwkObj->parse(ADMIN_SEARCH_BODY, $dd_data) . $output));
	exit;
										#*********************
	case 'add_items':					# ACTION: ADD PRODUCT
		echo $frmwkObj->parse(TEMPLATE,array('BODY' => $frmwkObj->parse(ADD_PRODUCT,array('RETURN_ARG' => $_GET['r']))));
	exit;

    case 'check_in':					# ACTION: ADD REPAIR
		$adminObj->check_in(array("ERROR_MESSAGE" => "","VALUE" => "",'ERROR_SCRIPT' => ''));
	exit;

        case 'system_profiler':					# ACTION: ADD REPAIR
		$adminObj->system_profiler();
	exit;

        case 'add_repair':					# ACTION: ADD REPAIR
		$adminObj->add_items(array("ERROR_MESSAGE" => "","VALUE" => ""));
	exit;
										#*********************
	case 'save_product':				# ACTION:SAVE PRODUCT DETAILS TO DATABASE
		$data = array();
		$data['pNum'] = $_POST['pNum'];
		$data['pName'] = $_POST['pName'];
		$data['pPrice'] = $_POST['pPrice'];
		if(isset($_POST['taxable'])){
			$data['taxable'] = $_POST['taxable'];
		}
		//$data['pTeaser'] = '';
		if($adminObj->add_product($data) > 0 ){
                    if ($_POST['returnArg'] != ''){
                        $frmwkObj->goToUrl(CONTROLLER.'?m=edit_items');
                    }else{
                        $frmwkObj->goToUrl(CONTROLLER);
                    }

		}else{
			$frmwkObj->error_page("DATABASE INSERTION ERROR");
		}
	exit;
}

# SUPER ADMIN ACTIONS FOLLOW
if ($adminObj->is_super()) {
	switch ($action) {
										#**********************
		case 'export_orders':			# ACTION: EXPORT ORDERS
			if (list($results, $youSearched) = $searchObj->run(
					$search, $query, $_GET['cStatus'], $_GET['toDate'], $_GET['fromDate'], $_GET['dt']
				)
			) {
                                $dd_data['PAYFLOW_TOTAL'] = $adminObj->get_payflow_totals();
				echo $frmwkObj->parse(TEMPLATE, array('BODY' => $frmwkObj->parse(ADMIN_SEARCH_BODY, $dd_data) . $output
						. $frmwkObj->parse(ORDER_EXPORT, array('CHECKBOXES' => $searchObj->checkboxes($results)))
					)
				);
			}
		exit;
										#*****************************
		case 'ccNum':					# ACTION: SHOW FULL CC NUMBER
			echo $frmwkObj->parse(TEMPLATE, array(
				'BODY' => '<p class="error" align="center">' . $_SESSION['ccNum'] . '</p>'
						. '<input type="button" value="Close" onclick="window.close();">'
			));
		exit;
										#*****************************
		case 'export_orders_submit':	# ACTION: EXPORT ORDERS STEP 2
			switch ($_POST['submit_action']) {
				case ORDER_EXPORT_BUTTON:
					$searchObj->export_orders($_POST['exportList']);
					exit;
				case ORDER_EXPORT2_BUTTON:
					$searchObj->export_customers($_POST['exportList']);
					exit;
                                case ORDER_EXPORT3_BUTTON:
					$searchObj->export_details($_POST['exportList']);
					exit;
                                case ORDER_EXPORT4_BUTTON:
					$searchObj->audit_export($_POST['exportList']);
					exit;
			}
	}
}

# NO ACTION, SHOW DEFAULT PAGE
$dd_data['PAYFLOW_TOTAL'] = $adminObj->get_payflow_totals();
echo $frmwkObj->parse(TEMPLATE, array(
		'BODY' => $frmwkObj->parse(ADMIN_SEARCH_BODY, $dd_data) . $searchObj->display_default()
	)
);

?>
