/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.plugin.cache.JarCacheTableCellRenderer;
import sun.plugin.cache.JarCacheTableColumn;
import sun.plugin.cache.JarCacheTableColumnModel;
import sun.plugin.cache.JarCacheTableHeaderRenderer;
import sun.plugin.cache.JarCacheTableSorter;

public class JarCacheTable
extends JTable {
    public static final Font tableFont = new Font("Dialog", 0, 10);
    private final Color shadeColor = new Color(232, 232, 232);
    private DefaultTableCellRenderer tableCellRenderer = new JarCacheTableCellRenderer(tableFont, this.shadeColor);
    private JarCacheTableColumnModel tableColumnModel = new JarCacheTableColumnModel();
    private JarCacheTableColumn[] tableColumns = null;
    private JarCacheTableSorter sorter = null;
    private String[] colNames = null;

    public JarCacheTable() {
        int n;
        this.sizeColumnsToFit(3);
        this.setAutoResizeMode(0);
        this.setColumnModel(this.tableColumnModel);
        this.tableColumns = this.tableColumnModel.getColumnArray();
        this.colNames = new String[this.tableColumns.length];
        for (n = 0; n < this.tableColumns.length; ++n) {
            this.colNames[n] = this.tableColumns[n].getHeaderValue().toString();
        }
        this.sorter = new JarCacheTableSorter(this.colNames);
        this.sorter.addMouseListenerToHeaderInTable(this);
        this.setModel(this.sorter);
        n = this.tableColumnModel.getColumnCount();
        TableColumn tableColumn = null;
        for (int i = 0; i < n; ++i) {
            tableColumn = this.columnModel.getColumn(i);
            if (this.tableColumns[i].isVisible()) {
                tableColumn.setMinWidth(this.tableColumns[i].getMinWidth());
                tableColumn.setPreferredWidth(this.tableColumns[i].getPreferredWidth());
                tableColumn.setResizable(this.tableColumns[i].getResizable());
                continue;
            }
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
        this.setHeaderRenderers();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheTable.this.removeRows();
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(127, 0), 2);
        this.getTableHeader().setReorderingAllowed(false);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void refresh() {
        this.sorter.refresh();
    }

    public void removeRows() {
        this.sorter.removeRows(this.getSelectedRows());
    }

    public void setHeaderRenderers() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(new JarCacheTableHeaderRenderer());
        }
    }

    public void adjustColumnSize(Container container) {
        int n = this.tableColumnModel.getColumnCount();
        int n2 = 0;
        int n3 = 0;
        TableColumn tableColumn = null;
        for (int i = 0; i < n - 1; ++i) {
            tableColumn = this.columnModel.getColumn(i);
            if (!this.tableColumns[i].isVisible()) continue;
            n2 += this.tableColumns[i].getWidth();
            n3 += tableColumn.getPreferredWidth();
        }
        n3 = n2;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        tableColumn = this.columnModel.getColumn(n - 1);
        int n4 = (int)(dimension.getWidth() - (double)n3 - (double)insets.left - (double)insets.right - 3.0);
        tableColumn.setPreferredWidth(n4);
    }

    public Font getFont() {
        return tableFont;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.tableCellRenderer;
    }

    public JarCacheTableColumn[] getJarCacheTableColumns() {
        return this.tableColumns;
    }

    public JarCacheTableColumnModel getJarCacheTableColumnModel() {
        return this.tableColumnModel;
    }
}

