/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.WeakHashMap;
import sun.plugin.util.UserProfile;

public class URLUtil {
    private static boolean doIPLookup = true;
    private static File HOST_FILE_DIR;
    private static WeakHashMap canonicalizedURLMap;

    static {
        canonicalizedURLMap = new WeakHashMap();
        HOST_FILE_DIR = new File(UserProfile.getPluginCacheDirectory() + File.separator + "host");
        HOST_FILE_DIR.mkdirs();
    }

    public static void setDoIPLookup(boolean bl) {
        doIPLookup = bl;
    }

    protected static int hashCode(String string) {
        int n = string.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public static void updateSocketHostIPFile(String string) {
        if (string == null) {
            return;
        }
        File file = URLUtil.getHostFile(string);
        boolean bl = file.exists();
        if (bl) {
            String string2 = URLUtil.getIPFromFile(file);
            URLUtil.isCachedHostIPValid(string, string2, file);
        } else {
            URLUtil.createHostFile(string, file);
        }
    }

    private static File getHostFile(String string) {
        int n = URLUtil.hashCode(string.toLowerCase());
        if (n < 0) {
            n += Integer.MIN_VALUE;
        }
        String string2 = Integer.toString(n, 16);
        return new File(HOST_FILE_DIR, string2 + ".hst");
    }

    public static void createHostFile(String string, final File file) {
        if (string == null || file == null) {
            return;
        }
        final String string2 = URLUtil.getHostIP(string);
        if (string2 != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string2);
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    private static void updateHostFile(String string, final File file) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                file.delete();
                return null;
            }
        });
        URLUtil.createHostFile(string, file);
    }

    public static String getIPFromFile(final File file) {
        String string = null;
        if (file == null) {
            return null;
        }
        string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = null;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
        });
        return string;
    }

    public static synchronized String canonicalize(String string) {
        if (string.indexOf("file:") == -1) {
            return string;
        }
        String string2 = (String)canonicalizedURLMap.get(string);
        if (string2 != null) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf("file://///") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(10));
        } else if (string.indexOf("file:///\\") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(9));
        } else if (string.indexOf("file://\\") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(9));
        } else if (string.indexOf("file:\\") == 0) {
            if (string.indexOf(58, 6) != -1 || string.indexOf(124, 6) != -1) {
                stringBuffer.append("file:///");
            } else {
                stringBuffer.append("file:////");
            }
            stringBuffer.append(string.substring(6));
        } else if (string.indexOf("file://") == 0 && string.charAt(7) != '/') {
            if (string.indexOf(58, 7) != -1 || string.indexOf(124, 7) != -1) {
                stringBuffer.append("file:///");
            } else {
                stringBuffer.append("file:////");
            }
            stringBuffer.append(string.substring(7));
        } else {
            stringBuffer.append(string);
        }
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '\\') {
                stringBuffer.setCharAt(i, '/');
                continue;
            }
            if (bl || c != '|') continue;
            stringBuffer.setCharAt(i, ':');
            bl = true;
        }
        String string3 = stringBuffer.toString();
        canonicalizedURLMap.put(string, string3);
        return string3;
    }

    public static String getHostIP(String string) {
        if (!doIPLookup) {
            return null;
        }
        String string2 = null;
        InetAddress inetAddress = null;
        if (string == null) {
            return string2;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress != null) {
            string2 = inetAddress.getHostAddress();
        }
        return string2;
    }

    public static boolean isCachedHostIPValid(String string, String string2, File file) {
        boolean bl = true;
        if (string2 == null) {
            return bl;
        }
        String string3 = URLUtil.getCurrentIP(string, string2);
        if (string3 == null) {
            return true;
        }
        if (!string3.equals(string2)) {
            bl = false;
        }
        if (file != null && string2 != null && !string3.equals(string2)) {
            URLUtil.updateHostFile(string, file);
        }
        return bl;
    }

    private static String getCurrentIP(String string, String string2) {
        Method method;
        if (string == null || string2 == null) {
            return null;
        }
        if (!doIPLookup) {
            return null;
        }
        String string3 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.InetAddress");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Object[] objectArray = new Object[]{string, inetAddress};
        Class[] classArray = new Class[2];
        try {
            classArray[0] = Class.forName("java.lang.String");
            classArray[1] = clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            method = clazz.getDeclaredMethod("getByName", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
        if (!Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = (InetAddress)method.invoke((Object)null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (inetAddress2 != null) {
            string3 = inetAddress2.getHostAddress();
        }
        return string3;
    }
}

