/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.util.DialogFactory;

public class UpdatePanel
extends ActivatorSubPanel
implements ActionListener {
    private MessageHandler mh = new MessageHandler("update");
    private static final String update_image = "sun/plugin/panel/JavaUpdateIcon-48.png";
    private JButton updateButton;
    private JButton advancedButton;
    private JComboBox notify;
    private JCheckBox updateCheckBox;
    private JLabel textDescLabel;
    private JLabel lastRunLabel;
    private String textDesc;
    private DateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
    private String sysTrayIconText = this.mh.getMessage("desc_systrayicon.text");
    private String ntfyInstallText = this.mh.getMessage("notify_install.text");
    private String ntfyDownldText = this.mh.getMessage("notify_download.text");
    private String[] weekDays;
    private String[] atComboBoxText;

    public void reset() {
        if (this.model.getUpdateSchedPlatform()) {
            this.updateCheckBox.setSelected(this.model.getAutoUpdateCheckEnabled());
        } else {
            this.updateCheckBox.setEnabled(false);
        }
        this.notify.setSelectedIndex(this.model.getUpdateNotify());
        this.setText();
        String string = this.model.getUpdateLastRun();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(this.df.parse(string));
        }
        catch (Exception exception) {
            string = null;
            System.out.println("got exception:" + exception);
        }
        if (string == null) {
            string = new String("    ");
        } else {
            DateFormat dateFormat = DateFormat.getTimeInstance(3);
            DateFormat dateFormat2 = DateFormat.getDateInstance(3);
            MessageFormat messageFormat = new MessageFormat(this.mh.getMessage("lastrun.text"));
            String string2 = dateFormat.format(gregorianCalendar.getTime());
            String string3 = dateFormat2.format(gregorianCalendar.getTime());
            string = messageFormat.format(new String[]{string2, string3});
        }
        this.lastRunLabel.setText(string);
    }

    private void setText() {
        if (!this.updateCheckBox.isSelected()) {
            this.notify.setEnabled(false);
            this.advancedButton.setEnabled(false);
            this.textDesc = this.mh.getMessage("desc_autooff.text");
            this.textDescLabel.setText(this.textDesc);
        } else {
            MessageFormat messageFormat;
            this.notify.setEnabled(true);
            this.advancedButton.setEnabled(true);
            int n = this.model.getUpdateFrequency();
            String string = this.atComboBoxText[this.model.getUpdateSchedule()];
            String string2 = null;
            if (n == 0) {
                this.textDesc = this.mh.getMessage("desc_check_daily.text");
                messageFormat = new MessageFormat(this.textDesc);
                this.textDesc = messageFormat.format(new String[]{string});
            } else if (n == 2) {
                this.textDesc = this.mh.getMessage("desc_check_monthly.text");
                string2 = String.valueOf(this.model.getUpdateDay());
            } else {
                this.textDesc = this.mh.getMessage("desc_check_weekly.text");
                string2 = String.valueOf(this.weekDays[this.model.getUpdateDay()]);
            }
            if (string2 != null) {
                messageFormat = new MessageFormat(this.textDesc);
                this.textDesc = messageFormat.format(new String[]{string2, string});
            }
            this.textDesc = this.textDesc + this.sysTrayIconText;
            n = this.notify.getSelectedIndex();
            this.textDesc = n == 1 ? this.textDesc + this.mh.getMessage("desc_notify_download.text") : this.textDesc + this.mh.getMessage("desc_notify_install.text");
            this.textDescLabel.setText(this.textDesc);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.updateButton) {
                String string = System.getProperty("java.home") + File.separator + "bin" + File.separator + "jucheck.exe";
                try {
                    Runtime.getRuntime().exec(string);
                }
                catch (IOException iOException) {
                    String[] stringArray = new String[]{"cmd", "/c", string};
                    Runtime.getRuntime().exec(stringArray);
                }
            } else if (actionEvent.getSource() == this.advancedButton) {
                new AdvancedDialog(this, this.model, this.mh);
            } else if (actionEvent.getSource() == this.notify) {
                int n = this.notify.getSelectedIndex();
                this.model.setUpdateNotify(n);
                this.setText();
            } else if (actionEvent.getSource() == this.updateCheckBox) {
                boolean bl = this.updateCheckBox.isSelected();
                this.model.setAutoUpdateCheckEnabled(bl);
                this.setText();
            }
        }
        catch (Exception exception) {
            DialogFactory.showExceptionDialog(this, exception);
        }
    }

    public String[] getAtComboBoxText() {
        return this.atComboBoxText;
    }

    public String[] getWeekDays() {
        return this.weekDays;
    }

    UpdatePanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource(update_image));
        jLabel.setIcon(imageIcon);
        jPanel.add(jLabel);
        this.add(jPanel);
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm");
        this.weekDays = dateFormatSymbols.getWeekdays();
        this.atComboBoxText = new String[24];
        for (int i = 0; i < 24; ++i) {
            try {
                Date date = simpleDateFormat.parse(i + ":00");
                this.atComboBoxText[i] = dateFormat.format(date);
                continue;
            }
            catch (Exception exception) {
                this.atComboBoxText[i] = i + ":00";
            }
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel2 = new JLabel(this.mh.getMessage("desc.text"));
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        jPanel2.add((Component)new JLabel(this.mh.getMessage("notify.text")), gridBagConstraints);
        this.notify = new JComboBox();
        this.notify.setMaximumRowCount(3);
        this.notify.addItem(this.ntfyInstallText);
        this.notify.addItem(this.ntfyDownldText);
        this.notify.addActionListener(this);
        gridBagConstraints.insets = new Insets(10, 0, 0, 15);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.notify, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridwidth = -1;
        this.updateCheckBox = new JCheckBox(this.mh.getMessage("autoupdate.text"));
        this.updateCheckBox.addActionListener(this);
        jPanel2.add((Component)this.updateCheckBox, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 15, 0, 15);
        this.advancedButton = new JButton(this.mh.getMessage("advanced_button.text"));
        this.advancedButton.addActionListener(this);
        jPanel2.add((Component)this.advancedButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.textDescLabel = new JLabel(" ");
        jPanel2.add((Component)this.textDescLabel, gridBagConstraints);
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.gridwidth = -1;
        this.lastRunLabel = new JLabel(" ");
        jPanel2.add((Component)this.lastRunLabel, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this.updateButton = new JButton(this.mh.getMessage("update_button.text"));
        this.updateButton.addActionListener(this);
        jPanel2.add((Component)this.updateButton, gridBagConstraints);
        this.add(jPanel2);
        this.reset();
    }

    private class AdvancedDialog
    implements ActionListener {
        ChangeListener changeListener = new ChangeListener(this){
            private final /* synthetic */ AdvancedDialog this$1;

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    if (changeEvent.getSource() == this.this$1.daymodel) {
                        this.this$1.setPanelOptions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            {
                this.this$1 = advancedDialog;
            }
        };
        private JRadioButton RButton1;
        private JRadioButton RButton2;
        private JRadioButton RButton3;
        private ButtonGroup FreqGroup;
        private String[] weekDays;
        private String[] atComboBoxText;
        private JComboBox at;
        private JComboBox every;
        JSpinner day;
        SpinnerNumberModel daymodel;
        private String atLabelText;
        private String everyLabelText;
        private String dayLabelText;
        private JLabel whenLabel1;
        private JLabel whenLabel2;
        private JLabel descLabel;
        private JLabel dummyLabel;
        JPanel whenPanel1;
        JPanel whenPanel2;
        JPanel whenPanel;
        GridBagConstraints c;

        void reset() {
        }

        void setPanelOptions() {
            MessageFormat messageFormat;
            String string = null;
            String string2 = null;
            if (this.RButton1.isSelected()) {
                this.day.setVisible(false);
                this.every.setVisible(false);
                this.whenLabel1.setText("  ");
                this.whenLabel2.setText(this.atLabelText);
                this.whenPanel1.add(this.dummyLabel);
                this.whenPanel2.add(this.at);
                this.at.setVisible(true);
                this.dummyLabel.setVisible(true);
                string = UpdatePanel.this.mh.getMessage("advanced_desc1.text");
                messageFormat = new MessageFormat(string);
                string = messageFormat.format(new String[]{(String)this.at.getItemAt(this.at.getSelectedIndex())});
            } else if (this.RButton2.isSelected()) {
                this.day.setVisible(false);
                this.dummyLabel.setVisible(false);
                this.whenLabel1.setText(this.everyLabelText);
                this.whenLabel2.setText(this.atLabelText);
                this.whenPanel1.add((Component)this.every, this.c);
                this.whenPanel2.add(this.at);
                this.every.setVisible(true);
                this.at.setVisible(true);
                string2 = (String)this.every.getItemAt(this.every.getSelectedIndex());
                string = UpdatePanel.this.mh.getMessage("advanced_desc2.text");
            } else if (this.RButton3.isSelected()) {
                this.dummyLabel.setVisible(false);
                this.every.setVisible(false);
                this.whenLabel1.setText(this.dayLabelText);
                this.whenLabel2.setText(this.atLabelText);
                this.whenPanel1.add(this.day);
                this.whenPanel2.add(this.at);
                this.day.setVisible(true);
                this.at.setVisible(true);
                string2 = String.valueOf((Integer)this.day.getValue());
                string = UpdatePanel.this.mh.getMessage("advanced_desc3.text");
            }
            if (string2 != null) {
                messageFormat = new MessageFormat(string);
                string = messageFormat.format(new String[]{string2, (String)this.at.getItemAt(this.at.getSelectedIndex())});
            }
            this.descLabel.setText(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == this.RButton1 || actionEvent.getSource() == this.RButton2 || actionEvent.getSource() == this.RButton3 || actionEvent.getSource() == this.every || actionEvent.getSource() == this.at) {
                    this.setPanelOptions();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public AdvancedDialog(UpdatePanel updatePanel2, ConfigurationInfo configurationInfo, MessageHandler messageHandler) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.anchor = 17;
            this.c.fill = 0;
            this.c.insets = new Insets(5, 0, 0, 0);
            this.c.weighty = 1.0;
            this.c.weightx = 0.0;
            this.c.gridwidth = 0;
            jPanel.add((Component)new JLabel(messageHandler.getMessage("advanced_title1.text")), this.c);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            Border border = BorderFactory.createEtchedBorder();
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, messageHandler.getMessage("advanced_title2.text"))));
            this.RButton1 = new JRadioButton(messageHandler.getMessage("check_daily.text"));
            this.RButton2 = new JRadioButton(messageHandler.getMessage("check_weekly.text"));
            this.RButton3 = new JRadioButton(messageHandler.getMessage("check_monthly.text"));
            this.FreqGroup = new ButtonGroup();
            this.FreqGroup.add(this.RButton1);
            this.FreqGroup.add(this.RButton2);
            this.FreqGroup.add(this.RButton3);
            this.RButton1.addActionListener(this);
            this.RButton2.addActionListener(this);
            this.RButton3.addActionListener(this);
            jPanel2.add(this.RButton1);
            jPanel2.add(this.RButton2);
            jPanel2.add(this.RButton3);
            this.c.weighty = 3.0;
            this.c.weightx = 0.0;
            this.c.gridwidth = 2;
            this.c.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jPanel2, this.c);
            this.whenPanel = new JPanel();
            this.whenPanel.setLayout(new GridBagLayout());
            this.whenPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, messageHandler.getMessage("advanced_title3.text"))));
            this.atComboBoxText = updatePanel2.getAtComboBoxText();
            this.weekDays = updatePanel2.getWeekDays();
            this.dummyLabel = new JLabel("    ");
            this.everyLabelText = messageHandler.getMessage("check_day.text");
            this.atLabelText = messageHandler.getMessage("check_time.text");
            this.dayLabelText = messageHandler.getMessage("check_date.text");
            this.whenLabel1 = new JLabel();
            this.whenLabel2 = new JLabel();
            this.every = new JComboBox();
            this.every.setMaximumRowCount(7);
            this.every.addItem(this.weekDays[1]);
            this.every.addItem(this.weekDays[2]);
            this.every.addItem(this.weekDays[3]);
            this.every.addItem(this.weekDays[4]);
            this.every.addItem(this.weekDays[5]);
            this.every.addItem(this.weekDays[6]);
            this.every.addItem(this.weekDays[7]);
            this.every.addActionListener(this);
            this.at = new JComboBox();
            this.at.setMaximumRowCount(this.atComboBoxText.length);
            for (int i = 0; i < this.atComboBoxText.length; ++i) {
                this.at.addItem(this.atComboBoxText[i]);
            }
            this.at.addActionListener(this);
            this.daymodel = new SpinnerNumberModel(1, 1, 31, 1);
            this.day = new JSpinner(this.daymodel);
            this.daymodel.addChangeListener(this.changeListener);
            this.c.anchor = 17;
            this.whenPanel1 = new JPanel();
            this.whenPanel2 = new JPanel();
            this.c.insets = new Insets(0, 10, 0, 5);
            this.c.gridwidth = 2;
            this.c.gridheight = 2;
            this.c.weighty = 0.0;
            this.c.weightx = 0.0;
            this.whenPanel.add((Component)this.whenLabel1, this.c);
            this.c.gridwidth = 0;
            this.c.weightx = 1.0;
            this.c.fill = 2;
            this.whenPanel.add((Component)this.whenPanel1, this.c);
            this.c.gridwidth = 2;
            this.c.fill = 0;
            this.c.weightx = 0.0;
            this.c.gridheight = 0;
            this.whenPanel.add((Component)this.whenLabel2, this.c);
            this.c.weightx = 1.0;
            this.c.fill = 2;
            this.c.gridwidth = 0;
            this.whenPanel.add((Component)this.whenPanel2, this.c);
            this.c.weightx = 2.0;
            this.c.weighty = 3.0;
            this.c.fill = 1;
            this.c.gridheight = -1;
            this.c.insets = new Insets(0, 5, 0, 0);
            this.c.gridwidth = 0;
            jPanel.add((Component)this.whenPanel, this.c);
            if (configurationInfo.getUpdateFrequency() == 0) {
                this.RButton1.setSelected(true);
            } else if (configurationInfo.getUpdateFrequency() == 2) {
                this.RButton3.setSelected(true);
                this.day.setValue(new Integer(configurationInfo.getUpdateDay()));
            } else {
                this.RButton2.setSelected(true);
                this.every.setSelectedIndex(configurationInfo.getUpdateDay() - 1);
            }
            this.at.setSelectedIndex(configurationInfo.getUpdateSchedule());
            this.descLabel = new JLabel("  ");
            this.descLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, "")));
            this.c.fill = 2;
            this.c.weightx = 1.0;
            this.c.weighty = 1.0;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.c.gridwidth = 0;
            jPanel.add((Component)this.descLabel, this.c);
            this.setPanelOptions();
            JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2);
            JDialog jDialog = jOptionPane.createDialog(null, messageHandler.getMessage("advanced_title.text"));
            jDialog.setModal(true);
            jDialog.setDefaultCloseOperation(2);
            jDialog.show();
            Integer n = (Integer)jOptionPane.getValue();
            if (n != null && n == 0) {
                configurationInfo.setUpdateSchedule(this.at.getSelectedIndex());
                if (this.RButton1.isSelected()) {
                    configurationInfo.setUpdateFrequency(0);
                    configurationInfo.setUpdateDay(0);
                } else if (this.RButton3.isSelected()) {
                    configurationInfo.setUpdateFrequency(2);
                    configurationInfo.setUpdateDay((Integer)this.day.getValue());
                } else {
                    configurationInfo.setUpdateFrequency(1);
                    configurationInfo.setUpdateDay(this.every.getSelectedIndex() + 1);
                }
            }
            updatePanel2.setText();
        }
    }
}

