/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.http;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.net.www.MessageHeader;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.DownloadException;
import sun.plugin.cache.FileCache;
import sun.plugin.net.cookie.PluginCookieManager;
import sun.plugin.net.protocol.http.Handler;
import sun.plugin.net.protocol.http.HttpClient;
import sun.plugin.net.proxy.PluginProxyManager;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.ProgressInputStream;
import sun.plugin.util.ThreadGroupLocal;
import sun.plugin.util.Trace;

public class HttpURLConnection
extends sun.net.www.protocol.http.HttpURLConnection {
    private String proxy = null;
    private int proxyPort = -1;
    private boolean resolveProxy = true;
    boolean failedOnce = false;
    private MessageHeader cachedHeaders = null;
    private boolean progressTracking = false;
    private static MessageFormat mf1 = new MessageFormat(ResourceHandler.getMessage("net.connect.no_proxy"));
    private static MessageFormat mf2 = new MessageFormat(ResourceHandler.getMessage("net.connect.proxy_is"));
    private int callCount = 0;
    private InputStream cacheStream = null;
    private IOException failedException = null;
    private boolean securityCheck = false;
    private boolean cacheConnect = false;
    private boolean realConnect = false;
    private boolean checkSetCookie = false;
    private boolean setUserCookie = true;
    private String userCookie = null;

    public synchronized void addCookieHeader() {
        String string = PluginCookieManager.getCookieInfo(this.url);
        if (string != null) {
            this.addRequestProperty("cookie", string);
        }
        this.checkSetCookie = false;
    }

    public synchronized void checkCookieHeader() {
        if (this.checkSetCookie) {
            return;
        }
        this.checkSetCookie = true;
        Map<String, List<String>> map = this.getHeaderFields();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null || !string.equalsIgnoreCase("Set-Cookie")) continue;
            List<String> list = map.get(string);
            Iterator<String> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                if (string2 == null) continue;
                PluginCookieManager.setCookieInfo(this.url, string2);
            }
        }
    }

    private void checkPermission() throws IOException {
        if (this.securityCheck) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        this.securityCheck = true;
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.checkPermission();
        if (this.getRequestMethod().equalsIgnoreCase("GET") && ThreadGroupLocal.get("javaplugin.progressTracking") != null) {
            this.progressTracking = true;
        }
        try {
            this.connectWithCache();
        }
        catch (DownloadException downloadException) {
            this.cachedHeaders = downloadException.getHeaders();
            this.failedException = downloadException.getIOException();
            throw this.failedException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cacheStream == null) {
            this.connectSetup();
            this.createConnection();
        }
        this.connected = true;
    }

    private void connectSetup() throws IOException {
        Object object;
        if (this.realConnect) {
            return;
        }
        if (this.proxy == null && this.resolveProxy && (object = PluginProxyManager.getProxyInfo(this.url)) != null) {
            this.proxy = object.getProxy();
            this.proxyPort = object.getPort();
        }
        if (this.proxy == null) {
            object = new Object[]{this.url};
            Trace.netPrintln(mf1.format(object), 2);
        } else {
            object = new Object[]{this.url, this.proxy + (this.proxyPort != -1 ? ":" + this.proxyPort : "")};
            Trace.netPrintln(mf2.format(object), 2);
        }
        if (this.setUserCookie) {
            this.userCookie = this.getRequestProperty("Cookie");
            this.setUserCookie = false;
        }
        object = PluginCookieManager.getCookieInfo(this.url);
        if (this.userCookie != null) {
            object = object != null ? (String)object + ";" + this.userCookie : this.userCookie;
        }
        if (object != null) {
            this.setRequestProperty("Cookie", (String)object);
        }
        this.realConnect = true;
    }

    private void connectWithCache() throws IOException {
        CachedFile cachedFile;
        if (this.cacheConnect) {
            return;
        }
        if (this.getUseCaches() && this.getRequestMethod().equalsIgnoreCase("GET") && (cachedFile = FileCache.get(this.url)) != null) {
            InputStream inputStream = null;
            try {
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new BufferedInputStream(new FileInputStream(cachedFile));
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (inputStream != null) {
                this.responseCode = 200;
                this.cachedHeaders = cachedFile.getHeaderFields();
                URL uRL = cachedFile.getURL();
                if (uRL != null) {
                    this.url = uRL;
                }
                this.cacheStream = this.progressTracking ? new ProgressInputStream(inputStream, this) : inputStream;
            }
        }
        this.cacheConnect = true;
    }

    void createConnection() throws IOException {
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url, this.proxy, this.proxyPort, this.resolveProxy) : this.getProxiedClient(this.url, this.proxy, this.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
    }

    public synchronized void disconnect() {
        super.disconnect();
        if (this.cacheStream != null) {
            this.cacheStream = null;
        }
        if (this.cachedHeaders != null) {
            this.cachedHeaders.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (this.failedException != null) {
            throw this.failedException;
        }
        this.connect();
        try {
            ++this.callCount;
            if (this.cacheStream != null) {
                InputStream inputStream = this.cacheStream;
                return inputStream;
            }
            InputStream inputStream = super.getInputStream();
            if (this.callCount == 1) {
                if (inputStream != null) {
                    this.cacheStream = this.progressTracking && !(inputStream instanceof ProgressInputStream) ? new ProgressInputStream(inputStream, this) : inputStream;
                }
                this.checkCookieHeader();
                InputStream inputStream2 = this.cacheStream;
                return inputStream2;
            }
            InputStream inputStream3 = inputStream;
            return inputStream3;
        }
        finally {
            --this.callCount;
        }
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != this.cachedHeaders) {
            return this.cachedHeaders.getValue(n);
        }
        return super.getHeaderField(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != this.cachedHeaders) {
            return this.cachedHeaders.getKey(n);
        }
        return super.getHeaderFieldKey(n);
    }

    public String getHeaderField(String string) {
        String string2 = null;
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string2 = this.cachedHeaders != null ? this.cachedHeaders.findValue(string) : super.getHeaderField(string);
        return string2;
    }

    public HttpURLConnection(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, true);
    }

    public HttpURLConnection(URL uRL, String string, int n, boolean bl) throws IOException {
        super(uRL, string, n);
        this.proxy = string;
        this.proxyPort = n;
        this.resolveProxy = bl;
    }

    protected sun.net.www.http.HttpClient getNewClient(URL uRL) throws IOException {
        this.failedOnce = true;
        return this.getProxiedClient(uRL, this.proxy, this.proxyPort);
    }

    public HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    protected sun.net.www.http.HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n, this.resolveProxy);
    }
}

