/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedJarFile;
import sun.plugin.cache.DownloadException;
import sun.plugin.cache.FileVersion;
import sun.plugin.cache.JarCache;
import sun.plugin.net.protocol.http.HttpUtils;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.ProgressTracker;
import sun.plugin.util.Trace;
import sun.plugin.util.URLUtil;

public class CachedJarLoader {
    private static int BUF_SIZE = 8192;
    private URL url;
    private HttpURLConnection uc = null;
    private long lastModified = 0L;
    private long expiration = 0L;
    private boolean upToDate = false;
    private boolean upToDateChecked = false;
    private File dataFile = null;
    private File indexFile = null;
    private File hostFile = null;
    private String codebaseIP = null;
    private boolean cached = false;
    private long size = 0L;
    private FileVersion version = new FileVersion();

    public long getJarSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress() throws IOException {
        ZipOutputStream zipOutputStream;
        ZipInputStream zipInputStream;
        boolean bl;
        block15: {
            bl = false;
            ZipInputStream zipInputStream2 = null;
            zipInputStream = null;
            zipOutputStream = null;
            try {
                Object object;
                zipInputStream = new ZipInputStream(new BufferedInputStream(this.uc.getInputStream(), BUF_SIZE));
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile), BUF_SIZE));
                zipOutputStream.setLevel(JarCache.compression);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (this.url.toString().toLowerCase().endsWith(".jarjar")) {
                    while (zipEntry != null) {
                        if (zipEntry.toString().toLowerCase().startsWith("meta-inf/")) {
                            zipEntry = zipInputStream.getNextEntry();
                            continue;
                        }
                        if (zipEntry.toString().toLowerCase().endsWith(".jar")) break;
                        throw new IOException(ResourceHandler.getMessage("cache.jarjar.invalid_file"));
                    }
                    zipInputStream2 = zipInputStream;
                    zipInputStream = new ZipInputStream(zipInputStream);
                    zipEntry = zipInputStream.getNextEntry();
                }
                byte[] byArray = new byte[2048];
                while (zipEntry != null) {
                    int n;
                    object = (ZipEntry)zipEntry.clone();
                    ((ZipEntry)object).setCompressedSize(-1L);
                    zipOutputStream.putNextEntry((ZipEntry)object);
                    while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    zipOutputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                if (zipInputStream2 != null && (zipEntry = zipInputStream2.getNextEntry()) != null) {
                    object = null;
                    object = !zipEntry.toString().toLowerCase().endsWith(".jar") ? ResourceHandler.getMessage("cache.jarjar.invalid_file") : ResourceHandler.getMessage("cache.jarjar.multiple_jar");
                    throw new IOException((String)object);
                }
                bl = true;
                Object var10_9 = null;
                if (zipInputStream2 == null) break block15;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (zipInputStream2 != null) {
                    zipInputStream2.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (!bl) {
                    this.dataFile.delete();
                    this.indexFile.delete();
                }
                throw throwable;
            }
            zipInputStream2.close();
        }
        if (zipInputStream != null) {
            zipInputStream.close();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        if (!bl) {
            this.dataFile.delete();
            this.indexFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsIncomplete() throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            randomAccessFile.writeByte(0);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    private boolean getCacheFile() throws IOException {
        final CachedJarLoader cachedJarLoader = this;
        try {
            return (Boolean)AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    boolean bl = false;
                    bl = JarCache.getMatchingFile(cachedJarLoader);
                    return bl;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
    }

    private boolean isUpToDate() throws IOException {
        boolean bl = false;
        if (this.expiration != 0L && new Date().before(new Date(this.expiration))) {
            bl = true;
        }
        if (!bl && this.lastModified != 0L) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc.setIfModifiedSince(this.lastModified);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 304) {
                this.uc.disconnect();
                bl = true;
            } else if (n >= 200 && n <= 299) {
                long l = this.lastModified;
                long l2 = this.expiration;
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == l) {
                    this.uc.disconnect();
                    bl = true;
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(l));
                    String string2 = dateFormat.format(new Date(this.lastModified));
                    Cache.msgPrintln("cache.out_of_date", new Object[]{this.url, string, string2});
                    this.size = this.uc.getContentLength();
                }
            } else {
                Cache.msgPrintln("cache.response_warning", new Object[]{String.valueOf(n), this.url});
            }
        }
        return bl;
    }

    public void setExpiration(long l) {
        this.expiration = l;
    }

    public void setLastModify(long l) {
        this.lastModified = l;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    void setHostFile(File file) {
        this.hostFile = file;
    }

    public void setIndexFile(File file) {
        this.indexFile = file;
    }

    String getCodebaseIP() {
        return this.codebaseIP;
    }

    void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public URL getURL() {
        return this.url;
    }

    public CachedJarLoader(URL uRL, boolean bl) throws IOException {
        this.url = uRL;
        this.cached = this.getCacheFile();
        if (bl) {
            if (this.cached) {
                this.upToDate = this.isUpToDate();
                this.upToDateChecked = true;
            } else {
                this.size = Cache.getFileSizeFromServer(uRL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedJarFile authenticate() throws IOException {
        Object[] objectArray;
        boolean bl = false;
        JarFile jarFile = new JarFile(this.dataFile);
        ObjectOutputStream objectOutputStream = null;
        RandomAccessFile randomAccessFile = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Manifest manifest = null;
        try {
            randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            randomAccessFile.writeByte(0);
            randomAccessFile.writeUTF(this.url.toString());
            randomAccessFile.writeLong(this.lastModified);
            randomAccessFile.writeLong(this.expiration);
            randomAccessFile.writeInt(1);
            randomAccessFile.writeUTF(this.version.getVersionAsString());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(randomAccessFile.getFD()), BUF_SIZE));
            manifest = jarFile.getManifest();
            if (manifest != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                objectArray = new byte[2048];
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    object5 = enumeration.nextElement();
                    object4 = ((ZipEntry)object5).getName();
                    if (((String)object4).toLowerCase().startsWith("meta-inf/") && !((String)object4).equals("META-INF/INDEX.LIST")) continue;
                    object3 = null;
                    try {
                        object3 = jarFile.getInputStream((ZipEntry)object5);
                        while (((InputStream)object3).read((byte[])objectArray, 0, objectArray.length) != -1) {
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                    }
                    object2 = ((JarEntry)object5).getCertificates();
                    if (object2 != null && ((Certificate[])object2).length > 0) {
                        object = new int[((Certificate[])object2).length];
                        for (int i = 0; i < ((Certificate[])object2).length; ++i) {
                            int n = arrayList.indexOf(object2[i]);
                            if (n == -1) {
                                n = arrayList.size();
                                arrayList.add(object2[i]);
                            }
                            object[i] = n;
                        }
                        hashMap.put(object4, object);
                    }
                    this.removeSignature(manifest, (String)object4);
                }
                object5 = new ByteArrayOutputStream();
                manifest.write((OutputStream)object5);
                ((ByteArrayOutputStream)object5).close();
                object4 = ((ByteArrayOutputStream)object5).toByteArray();
                objectOutputStream.writeInt(((Object)object4).length);
                objectOutputStream.write((byte[])object4);
                if (!arrayList.isEmpty()) {
                    objectOutputStream.writeInt(arrayList.size());
                    object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        objectOutputStream.writeObject(object3.next());
                    }
                    object2 = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
                    object = hashMap.keySet().iterator();
                    String string = null;
                    while (object.hasNext()) {
                        String string2;
                        String string3 = (String)object.next();
                        int[] nArray = (int[])hashMap.get(string3);
                        if (string3.indexOf("/") != -1) {
                            string2 = string3.substring(0, string3.lastIndexOf("/"));
                            if (string != null && string2.equals(string)) {
                                string3 = string3.substring(string2.length());
                            }
                            string = string2;
                        }
                        ((Writer)object2).write(string3);
                        ((BufferedWriter)object2).newLine();
                        string2 = String.valueOf(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            string2 = string2 + " " + nArray[i];
                        }
                        ((BufferedWriter)object2).write(string2, 0, string2.length());
                        ((BufferedWriter)object2).newLine();
                    }
                    ((BufferedWriter)object2).flush();
                } else {
                    objectOutputStream.writeInt(0);
                }
            } else {
                objectOutputStream.writeInt(0);
            }
            objectOutputStream.flush();
            randomAccessFile.seek(0L);
            randomAccessFile.writeByte(16);
            bl = true;
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            jarFile.close();
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (!bl) {
                this.dataFile.delete();
                this.indexFile.delete();
            }
            throw throwable;
        }
        jarFile.close();
        if (objectOutputStream != null) {
            objectOutputStream.close();
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        if (!bl) {
            this.dataFile.delete();
            this.indexFile.delete();
        }
        objectArray = new Certificate[arrayList.size()];
        objectArray = (Certificate[])arrayList.toArray(objectArray);
        return new CachedJarFile(this.dataFile, (Certificate[])objectArray, hashMap, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedJarFile authenticateFromCache() throws IOException {
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        Certificate[] certificateArray = null;
        Manifest manifest = null;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "r");
        ObjectInputStream objectInputStream = null;
        try {
            randomAccessFile.readByte();
            randomAccessFile.readUTF();
            randomAccessFile.readLong();
            randomAccessFile.readLong();
            randomAccessFile.readInt();
            randomAccessFile.readUTF();
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(randomAccessFile.getFD()), BUF_SIZE));
            int n = objectInputStream.readInt();
            if (n > 0) {
                byte[] byArray = new byte[n];
                objectInputStream.readFully(byArray, 0, n);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                manifest = new Manifest();
                manifest.read(byteArrayInputStream);
                int n2 = objectInputStream.readInt();
                if (n2 > 0) {
                    certificateArray = new Certificate[n2];
                    try {
                        for (int i = 0; i < n2; ++i) {
                            certificateArray[i] = (Certificate)objectInputStream.readObject();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading certificates");
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(objectInputStream));
                    String string = bufferedReader.readLine();
                    String string2 = null;
                    while (string != null && !string.equals("")) {
                        String string3 = string;
                        if (string3.startsWith("/")) {
                            string3 = string2 + string3;
                        } else {
                            int n3 = string3.lastIndexOf("/");
                            if (n3 != -1) {
                                string2 = string3.substring(0, n3);
                            }
                        }
                        string = bufferedReader.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
                        int n4 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n4];
                        for (int i = 0; i < n4; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        hashMap.put(string3, nArray);
                        string = bufferedReader.readLine();
                    }
                    Cache.msgPrintln("cache.cert_load", new Object[]{this.url});
                }
            }
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            randomAccessFile.close();
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            throw throwable;
        }
        randomAccessFile.close();
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        return new CachedJarFile(this.dataFile, certificateArray, hashMap, manifest);
    }

    private CachedJarFile download() throws IOException {
        if (this.uc == null) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n < 200 || n >= 300) {
                throw new IOException("Could not connect to " + this.url + " with response code " + n);
            }
            this.lastModified = this.uc.getLastModified();
            this.expiration = this.uc.getExpiration();
        }
        if (this.lastModified == 0L && this.expiration == 0L) {
            Trace.msgPrintln("cache.header_fields_missing");
            return null;
        }
        Cache.msgPrintln("cache.downloading", new Object[]{this.url});
        try {
            return (CachedJarFile)AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    String string = JarCache.generateCacheFileName(CachedJarLoader.this.url);
                    CachedJarLoader.this.dataFile = new File(JarCache.directory, string + ".zip");
                    CachedJarLoader.this.indexFile = new File(JarCache.directory, string + ".idx");
                    CachedJarLoader.this.hostFile = new File(JarCache.directory, string + ".hst");
                    CachedJarLoader.this.markAsIncomplete();
                    CachedJarLoader.this.decompress();
                    CachedJarFile cachedJarFile = CachedJarLoader.this.authenticate();
                    URLUtil.createHostFile(CachedJarLoader.this.url.getHost(), CachedJarLoader.this.hostFile);
                    Cache.msgPrintln("cache.cached_name", new Object[]{CachedJarLoader.this.dataFile.getName()});
                    return cachedJarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
    }

    public CachedJarFile load() throws IOException {
        CachedJarFile cachedJarFile = this.loadFromCache();
        if (cachedJarFile == null) {
            try {
                cachedJarFile = this.download();
            }
            catch (IOException iOException) {
                int n;
                if (this.uc != null && ((n = this.uc.getResponseCode()) < 200 || n >= 300)) {
                    throw new DownloadException(iOException, this.uc);
                }
                throw iOException;
            }
            if (cachedJarFile != null && Cache.cleanupThread != null) {
                try {
                    AccessController.doPrivileged(new Cache.CacheIOAction(){

                        public Object run() throws IOException {
                            Cache.cleanupThread.addedJar(CachedJarLoader.this.dataFile.length() + CachedJarLoader.this.indexFile.length());
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new IOException(privilegedActionException.getMessage());
                }
            }
        }
        return cachedJarFile;
    }

    private CachedJarFile loadFromCache() {
        CachedJarFile cachedJarFile;
        block8: {
            cachedJarFile = null;
            boolean bl = true;
            try {
                if (!this.cached) break block8;
                bl = URLUtil.isCachedHostIPValid(this.url.getHost(), this.getCodebaseIP(), null);
                if (!this.upToDateChecked && bl) {
                    this.upToDate = this.isUpToDate();
                }
                if (this.upToDate && bl) {
                    Cache.msgPrintln("cache.loading", new Object[]{this.url});
                    ProgressTracker.onProgressComplete(this.url);
                    try {
                        cachedJarFile = (CachedJarFile)AccessController.doPrivileged(new Cache.CacheIOAction(){

                            public Object run() throws IOException {
                                CachedJarLoader.this.indexFile.setLastModified(System.currentTimeMillis());
                                return CachedJarLoader.this.authenticateFromCache();
                            }
                        });
                        break block8;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new IOException(privilegedActionException.getMessage());
                    }
                }
                try {
                    AccessController.doPrivileged(new Cache.CacheIOAction(){

                        public Object run() throws IOException {
                            Cache.removeFromTable(CachedJarLoader.this.indexFile, JarCache.filesInCache);
                            if (!CachedJarLoader.this.dataFile.delete()) {
                                CachedJarLoader.this.dataFile.deleteOnExit();
                            }
                            if (!CachedJarLoader.this.indexFile.delete()) {
                                FileOutputStream fileOutputStream = new FileOutputStream(CachedJarLoader.this.indexFile);
                                fileOutputStream.write(1);
                                fileOutputStream.close();
                                CachedJarLoader.this.indexFile.deleteOnExit();
                            }
                            if (!CachedJarLoader.this.hostFile.delete()) {
                                CachedJarLoader.this.hostFile.deleteOnExit();
                            }
                            CachedJarLoader.this.dataFile = null;
                            CachedJarLoader.this.indexFile = null;
                            CachedJarLoader.this.hostFile = null;
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new IOException(privilegedActionException.getMessage());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Cache.msgPrintln("cache.load_warning", new Object[]{this.url});
            }
        }
        return cachedJarFile;
    }

    public void setVersion(FileVersion fileVersion) {
        this.version = fileVersion;
    }

    public boolean isVersionUpToDate(FileVersion fileVersion) {
        boolean bl = false;
        this.upToDate = bl = this.version.isUpToDate(fileVersion);
        this.upToDateChecked = true;
        return bl;
    }

    private void removeSignature(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes != null) {
            Set<Object> set = ((Attributes)attributes.clone()).keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Attributes.Name name = (Attributes.Name)iterator.next();
                String string2 = name.toString();
                if (string2.endsWith("-Digest") || string2.indexOf("-Digest-") != -1) {
                    attributes.remove(name);
                }
                if (!string2.equals("Magic:")) continue;
                attributes.remove(name);
            }
            if (attributes.isEmpty()) {
                manifest.getEntries().remove(string);
            }
        }
    }
}

